/*
 * Decompiled with CFR 0.152.
 */
package io.github.sycamore0.myluckyblock.utils;

import io.github.sycamore0.myluckyblock.utils.LuckyEventFunctions;
import io.github.sycamore0.myluckyblock.utils.PosSrc;
import io.github.sycamore0.myluckyblock.utils.RandomEventReader;
import io.github.sycamore0.myluckyblock.utils.helper.PosHelper;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LuckyEventExecutor {
    public static void executeLuckyFunction(ServerLevel serverLevel, @Nullable Player player, BlockPos blockPos, RandomEventReader function) {
        if (function.hasDropItems()) {
            for (RandomEventReader.DropItem dropItem : function.getDropItems()) {
                int count;
                boolean isUseRandom = dropItem.isUseRandom();
                if (isUseRandom) {
                    int min = dropItem.getRandomNum().getMin();
                    int max = dropItem.getRandomNum().getMax();
                    count = LuckyEventExecutor.getRandomNumber(min, max);
                } else {
                    count = dropItem.getNum();
                }
                Vec3 dropItemPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, dropItem.getOffset(), "DropItems");
                if (player != null && dropItem.getPosSrc() != PosSrc.BLOCK) {
                    dropItemPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.blockPosition()), dropItem.getPosSrc(), dropItem.getOffset(), "DropItems");
                }
                LuckyEventFunctions.dropItems(serverLevel, dropItemPos, dropItem.getId(), count, dropItem.getName(), dropItem.isNameVisible(), dropItem.getDesc(), dropItem.getNbt());
            }
        }
        if (function.hasPlaceBlocks()) {
            for (RandomEventReader.PlaceBlock placeBlock : function.getPlaceBlocks()) {
                Vec3 placeBlockPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, placeBlock.getOffset(), "PlaceBlocks");
                if (player != null && placeBlock.getPosSrc() != PosSrc.BLOCK) {
                    placeBlockPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.blockPosition()), placeBlock.getPosSrc(), placeBlock.getOffset(), "PlaceBlocks");
                }
                LuckyEventFunctions.placeBlock(serverLevel, placeBlockPos, placeBlock.getId());
            }
        }
        if (function.hasPlaceChests()) {
            for (RandomEventReader.PlaceChest placeChest : function.getPlaceChests()) {
                ResourceKey lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)Identifier.parse((String)placeChest.getId()));
                Vec3 placeChestPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, placeChest.getOffset(), "PlaceChests");
                if (player != null && placeChest.getPosSrc() != PosSrc.BLOCK) {
                    placeChestPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.blockPosition()), placeChest.getPosSrc(), placeChest.getOffset(), "PlaceChests");
                }
                LuckyEventFunctions.placeChest(serverLevel, PosHelper.parseVec3d(placeChestPos), placeChest.getChestId(), (ResourceKey<LootTable>)lootTable);
            }
        }
        if (function.hasFallBlocks()) {
            for (RandomEventReader.FallBlock fallBlock : function.getFallBlocks()) {
                Optional blockIdOptional = BuiltInRegistries.BLOCK.get(Identifier.parse((String)fallBlock.getId()));
                if (!blockIdOptional.isPresent()) continue;
                Block blockId = (Block)((Holder.Reference)blockIdOptional.get()).value();
                Vec3 fallBlockPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, fallBlock.getOffset(), "FallBlocks");
                if (player != null && fallBlock.getPosSrc() != PosSrc.BLOCK) {
                    fallBlockPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.blockPosition()), fallBlock.getPosSrc(), fallBlock.getOffset(), "FallBlocks");
                }
                LuckyEventFunctions.fallBlock(serverLevel, PosHelper.parseVec3d(fallBlockPos), blockId, fallBlock.getVelocity());
            }
        }
        if (function.hasGivePotionEffects()) {
            for (RandomEventReader.GivePotionEffect givePotionEffect : function.getGivePotionEffects()) {
                if (player == null) continue;
                Holder.Reference effect = (Holder.Reference)BuiltInRegistries.MOB_EFFECT.get(Identifier.parse((String)givePotionEffect.getId())).orElseThrow();
                LuckyEventFunctions.givePotionEffect(player, (Holder<MobEffect>)effect, givePotionEffect.getDuration(), givePotionEffect.getAmplifier());
            }
        }
        if (function.hasSpawnMobs()) {
            for (RandomEventReader.SpawnMob spawnMob : function.getSpawnMobs()) {
                Optional entityTypeOptional = BuiltInRegistries.ENTITY_TYPE.get(Identifier.parse((String)spawnMob.getId()));
                if (!entityTypeOptional.isPresent()) continue;
                EntityType entityType = (EntityType)((Holder.Reference)entityTypeOptional.get()).value();
                boolean isUseRandom = spawnMob.isUseRandom();
                int count = isUseRandom ? LuckyEventExecutor.getRandomNumber(spawnMob.getRandomNum().getMin(), spawnMob.getRandomNum().getMax()) : spawnMob.getNum();
                Vec3 spawnMobPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, spawnMob.getOffset(), "SpawnMobs");
                if (player != null && spawnMob.getPosSrc() != PosSrc.BLOCK) {
                    spawnMobPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.blockPosition()), spawnMob.getPosSrc(), spawnMob.getOffset(), "SpawnMobs");
                }
                String nbtString = spawnMob.getNbt();
                for (int i = 0; i < count; ++i) {
                    if (entityType == EntityType.ITEM) {
                        LuckyEventFunctions.dropItemsByNbt(serverLevel, spawnMobPos, spawnMob.getName(), spawnMob.isNameVisible(), spawnMob.getDesc(), nbtString);
                        continue;
                    }
                    if (nbtString != null) {
                        LuckyEventFunctions.spawnMob(serverLevel, spawnMobPos, entityType, spawnMob.getRandomize(), spawnMob.getName(), (boolean)spawnMob.isNameVisible(), spawnMob.getVelocity(), nbtString);
                        continue;
                    }
                    LuckyEventFunctions.spawnMob(serverLevel, spawnMobPos, entityType, spawnMob.getRandomize(), spawnMob.getName(), (boolean)spawnMob.isNameVisible(), spawnMob.isBaby(), spawnMob.getVelocity());
                }
            }
        }
        if (function.hasSendMessages()) {
            for (RandomEventReader.SendMessage sendMessage : function.getSendMessages()) {
                if (player == null) continue;
                LuckyEventFunctions.sendMessage(player, sendMessage.getMsg());
            }
        }
        if (function.hasDisplayMessages()) {
            for (RandomEventReader.DisplayMessage displayMessage : function.getDisplayMessages()) {
                if (player == null) continue;
                LuckyEventFunctions.displayClientMessage(player, displayMessage.getMsg(), displayMessage.getOverlay());
            }
        }
        if (function.hasCreateExplosions()) {
            for (RandomEventReader.CreateExplosion createExplosion : function.getCreateExplosions()) {
                Vec3 createExplosionPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, createExplosion.getOffset(), "CreateExplosions");
                if (player != null && createExplosion.getPosSrc() != PosSrc.BLOCK) {
                    createExplosionPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.blockPosition()), createExplosion.getPosSrc(), createExplosion.getOffset(), "CreateExplosions");
                }
                LuckyEventFunctions.createExplosion(serverLevel, createExplosionPos, createExplosion.getPower(), createExplosion.isCreateFire());
            }
        }
        if (function.hasAddParticles()) {
            for (RandomEventReader.AddParticle addParticle : function.getAddParticles()) {
                Optional particleTypeOptional = BuiltInRegistries.PARTICLE_TYPE.get(Identifier.parse((String)addParticle.getId()));
                if (!particleTypeOptional.isPresent()) continue;
                ParticleType particleType = (ParticleType)((Holder.Reference)particleTypeOptional.get()).value();
                ParticleOptions particle = (ParticleOptions)particleType;
                Vec3 addParticlePos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, addParticle.getOffset(), "AddParticles");
                if (player != null && addParticle.getPosSrc() != PosSrc.BLOCK) {
                    addParticlePos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.blockPosition()), addParticle.getPosSrc(), addParticle.getOffset(), "AddParticles");
                }
                LuckyEventFunctions.addParticles(serverLevel, particle, addParticlePos, addParticle.getCount(), addParticle.getVelocity().getX(), addParticle.getVelocity().getY(), addParticle.getVelocity().getZ(), addParticle.getSpeed());
            }
        }
        if (function.hasPlaySounds()) {
            for (RandomEventReader.PlaySound playSound : function.getPlaySounds()) {
                Optional soundEventOptional;
                if (player == null || !(soundEventOptional = BuiltInRegistries.SOUND_EVENT.get(Identifier.parse((String)playSound.getId()))).isPresent()) continue;
                SoundEvent soundEvent = (SoundEvent)((Holder.Reference)soundEventOptional.get()).value();
                LuckyEventFunctions.playSound((Entity)player, serverLevel, PosHelper.parseBlockPos(blockPos), soundEvent, playSound.getVolume(), playSound.getPitch());
            }
        }
        if (function.hasLoadStructures()) {
            for (RandomEventReader.LoadStructure loadStructure : function.getLoadStructures()) {
                Vec3 loadStructurePos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, loadStructure.getOffset(), "LoadStructures");
                if (player != null && loadStructure.getPosSrc() != PosSrc.BLOCK) {
                    loadStructurePos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.blockPosition()), loadStructure.getPosSrc(), loadStructure.getOffset(), "LoadStructures");
                }
                LuckyEventFunctions.loadStructure(serverLevel, PosHelper.parseVec3d(loadStructurePos), loadStructure.getModId(), loadStructure.getId());
            }
        }
        if (function.hasExecuteCommands()) {
            for (RandomEventReader.ExecuteCommand executeCommand : function.getExecuteCommands()) {
                Vec3 executeCommandPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, executeCommand.getOffset(), "ExecuteCommands");
                if (player != null && executeCommand.getPosSrc() != PosSrc.BLOCK) {
                    executeCommandPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.blockPosition()), executeCommand.getPosSrc(), executeCommand.getOffset(), "ExecuteCommands");
                }
                LuckyEventFunctions.executeCommand(serverLevel, executeCommandPos, executeCommand.getCommand());
            }
        }
    }

    private static int getRandomNumber(int min, int max) {
        return min + new Random().nextInt(max - min + 1);
    }
}

