/*
 * Decompiled with CFR 0.152.
 */
package io.github.sycamore0.myluckyblock.utils;

import io.github.sycamore0.myluckyblock.Constants;
import io.github.sycamore0.myluckyblock.utils.helper.NbtHelper;
import io.github.sycamore0.myluckyblock.utils.helper.PosHelper;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.minecart.MinecartCommandBlock;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LuckyEventFunctions {
    @Deprecated
    public static void dropItems(ServerLevel serverLevel, Vec3 pos, String itemId, int count) {
        LuckyEventFunctions.dropItems(serverLevel, pos, itemId, count, null, false, null, null);
    }

    @Deprecated
    public static void dropItems(ServerLevel serverLevel, Vec3 pos, String itemId, int count, @Nullable String nbtString) {
        LuckyEventFunctions.dropItems(serverLevel, pos, itemId, count, null, false, null, nbtString);
    }

    public static void dropItems(ServerLevel serverLevel, Vec3 pos, String itemId, int count, @Nullable String name, boolean nameVisible, @Nullable String desc, @Nullable String nbtString) {
        Optional itemOptional = BuiltInRegistries.ITEM.get(Identifier.parse((String)itemId));
        if (itemOptional.isPresent()) {
            Item item = (Item)((Holder.Reference)itemOptional.get()).value();
            if (item.equals(Items.AIR)) {
                return;
            }
            ItemStack itemStack = new ItemStack((ItemLike)item, count);
            ItemEntity itemEntity = new ItemEntity((Level)serverLevel, pos.x(), pos.y(), pos.z(), itemStack);
            if (nbtString != null) {
                ValueInput nbt = NbtHelper.generateNewItemNbt(itemId, count, nbtString, serverLevel);
                if (nbt == null) {
                    return;
                }
                itemEntity.load(nbt);
            }
            if (name != null) {
                itemEntity.setCustomName((Component)Component.translatable((String)name));
                itemEntity.setCustomNameVisible(nameVisible);
                itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)name));
            }
            if (desc != null) {
                ItemLore itemLore = new ItemLore(List.of(Component.translatable((String)desc)));
                itemStack.set(DataComponents.LORE, (Object)itemLore);
            }
            itemEntity.setPos(pos);
            serverLevel.addFreshEntity((Entity)itemEntity);
        }
    }

    public static void dropItemsByNbt(ServerLevel serverLevel, Vec3 pos, @Nullable String name, boolean nameVisible, @Nullable String desc, @Nullable String nbtString) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.AIR);
        ItemEntity item = new ItemEntity((Level)serverLevel, pos.x(), pos.y(), pos.z(), itemStack);
        if (nbtString != null) {
            ValueInput nbt = NbtHelper.generateNewNbt(nbtString, serverLevel);
            if (nbt == null) {
                return;
            }
            item.load(nbt);
        }
        if (name != null) {
            item.setCustomName((Component)Component.translatableEscape((String)name, (Object[])new Object[0]));
            item.setCustomNameVisible(nameVisible);
            item.getItem().set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)name));
        }
        if (desc != null) {
            ItemLore itemLore = new ItemLore(List.of(Component.translatable((String)desc)));
            item.getItem().set(DataComponents.LORE, (Object)itemLore);
        }
        item.setPos(pos);
        serverLevel.addFreshEntity((Entity)item);
    }

    public static void placeBlock(ServerLevel serverLevel, Vec3 pos, String blockId) {
        Optional blockOptional = BuiltInRegistries.BLOCK.get(Identifier.parse((String)blockId));
        if (blockOptional.isPresent()) {
            Block block = (Block)((Holder.Reference)blockOptional.get()).value();
            BlockState blockState = block.defaultBlockState();
            BlockPos blockPos = PosHelper.parseVec3d(pos);
            serverLevel.setBlockAndUpdate(blockPos, blockState);
        }
    }

    public static void placeChest(ServerLevel serverLevel, BlockPos blockPos, String chestBlockId, ResourceKey<LootTable> lootTableId) {
        Optional chestBlockOptional = BuiltInRegistries.BLOCK.get(Identifier.parse((String)chestBlockId));
        if (chestBlockOptional.isPresent()) {
            Block chestBlock = (Block)((Holder.Reference)chestBlockOptional.get()).value();
            BlockState chestBlockState = chestBlock.defaultBlockState();
            serverLevel.setBlockAndUpdate(blockPos, chestBlockState);
            BlockEntity blockEntity = serverLevel.getBlockEntity(blockPos);
            if (blockEntity instanceof RandomizableContainer) {
                RandomizableContainer lootableInventory = (RandomizableContainer)blockEntity;
                lootableInventory.setLootTable(lootTableId);
            }
        }
    }

    public static void fallBlock(ServerLevel serverLevel, BlockPos blockPos, Block block, Vec3 velocity) {
        BlockState blockState = block.defaultBlockState();
        FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)serverLevel, (BlockPos)blockPos, (BlockState)blockState);
        fallingBlockEntity.push(velocity);
    }

    public static void spawnMob(ServerLevel serverLevel, Vec3 pos, EntityType<?> entityType, boolean randomize, @Nullable String name, boolean nameVisible, Vec3 velocity, @Nullable String nbtString) {
        ValueInput nbt;
        Entity entity = entityType.create((Level)serverLevel, EntitySpawnReason.MOB_SUMMONED);
        if (entity == null) {
            return;
        }
        if (randomize && entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            mobEntity.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(PosHelper.parseVec3d(pos)), EntitySpawnReason.NATURAL, null);
        }
        if ((nbt = NbtHelper.generateNewNbt(nbtString, serverLevel)) == null) {
            return;
        }
        entity.load(nbt);
        if (name != null) {
            entity.setCustomName((Component)Component.translatableEscape((String)name, (Object[])new Object[0]));
            entity.setCustomNameVisible(nameVisible);
        }
        entity.setPos(pos);
        entity.push(velocity);
        serverLevel.addFreshEntity(entity);
    }

    public static void spawnMob(ServerLevel serverLevel, Vec3 pos, EntityType<?> entityType, boolean randomize, @Nullable String name, boolean nameVisible, boolean isBaby, Vec3 velocity) {
        Mob mobEntity;
        Entity entity = entityType.create((Level)serverLevel, EntitySpawnReason.MOB_SUMMONED);
        if (entity == null) {
            return;
        }
        if (randomize && entity instanceof Mob) {
            mobEntity = (Mob)entity;
            mobEntity.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(PosHelper.parseVec3d(pos)), EntitySpawnReason.NATURAL, null);
        }
        if (name != null) {
            entity.setCustomName((Component)Component.translatableEscape((String)name, (Object[])new Object[0]));
            entity.setCustomNameVisible(nameVisible);
        }
        if (entity instanceof Mob) {
            mobEntity = (Mob)entity;
            mobEntity.setBaby(isBaby);
        }
        entity.setPos(pos);
        entity.push(velocity);
        serverLevel.addFreshEntity(entity);
    }

    public static void createExplosion(ServerLevel serverLevel, Vec3 pos, float power, boolean createFire) {
        serverLevel.explode(null, pos.x(), pos.y(), pos.z(), power, createFire, Level.ExplosionInteraction.BLOCK);
    }

    public static void sendMessage(Player player, String message) {
        player.displayClientMessage((Component)Component.translatableEscape((String)message, (Object[])new Object[0]), false);
    }

    public static void displayClientMessage(Player player, String message, boolean overlay) {
        player.displayClientMessage((Component)Component.translatableEscape((String)message, (Object[])new Object[0]), overlay);
    }

    public static void givePotionEffect(Player player, Holder<MobEffect> effect, int duration, int amplifier) {
        if (player != null) {
            player.addEffect(new MobEffectInstance(effect, duration, amplifier, false, true));
        }
    }

    public static void addParticles(ServerLevel serverLevel, ParticleOptions particleEffect, Vec3 pos, int count, double velocityX, double velocityY, double velocityZ, double speed) {
        serverLevel.sendParticles(particleEffect, pos.x(), pos.y(), pos.z(), count, velocityX, velocityY, velocityZ, speed);
    }

    public static void playSound(Entity entity, ServerLevel serverLevel, Vec3 pos, SoundEvent soundEvent, float volume, float pitch) {
        serverLevel.playSound(entity, PosHelper.parseVec3d(pos), soundEvent, SoundSource.BLOCKS, volume, pitch);
    }

    public static void loadStructure(ServerLevel serverLevel, BlockPos pos, String modId, String structureName) {
        MinecraftServer server = serverLevel.getServer();
        StructureTemplateManager manager = serverLevel.getStructureManager();
        Identifier structureId = Identifier.fromNamespaceAndPath((String)modId, (String)structureName);
        try {
            Optional<StructureTemplate> template = manager.get(structureId);
            if (template.isEmpty()) {
                Identifier resourcePath = Identifier.fromNamespaceAndPath((String)modId, (String)("structure/" + structureName + ".nbt"));
                ResourceManager resourceManager = server.getResourceManager();
                Resource resource = (Resource)resourceManager.getResource(resourcePath).orElseThrow();
                try (InputStream stream = resource.open();){
                    CompoundTag nbt = NbtIo.readCompressed((InputStream)stream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                    StructureTemplate structure = manager.readStructure(nbt);
                    template = Optional.of(structure);
                }
                catch (NoSuchFileException e) {
                    Constants.LOG.error("Structure file not exist: {}", (Object)resourcePath);
                    return;
                }
            }
            StructureTemplate structure = (StructureTemplate)template.get();
            StructurePlaceSettings placement = new StructurePlaceSettings().setIgnoreEntities(false).setKnownShape(true).setRotation(Rotation.NONE).setMirror(Mirror.NONE);
            structure.placeInWorld((ServerLevelAccessor)serverLevel, pos, pos, placement, serverLevel.getRandom(), 3);
        }
        catch (Exception e) {
            Constants.LOG.error("Catch error when loading structure: ", (Throwable)e);
        }
    }

    public static void executeCommand(ServerLevel serverLevel, Vec3 pos, String command) {
        MinecartCommandBlock cBMinecart = new MinecartCommandBlock(EntityType.COMMAND_BLOCK_MINECART, (Level)serverLevel);
        cBMinecart.setCustomName((Component)Component.translatableEscape((String)"myluckyblock", (Object[])new Object[0]));
        cBMinecart.getCommandBlock().setCommand(command);
        cBMinecart.setPos(pos.x(), pos.y(), pos.z());
        serverLevel.addFreshEntity((Entity)cBMinecart);
        cBMinecart.getCommandBlock().performCommand(serverLevel);
        cBMinecart.discard();
    }
}

