/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.attachment.v4;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.attachment.v4.DataAttachmentType;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.impl.attachment.DataAttachmentRegistryImpl;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;

public final class DataAttachmentRegistry {
    private DataAttachmentRegistry() {
    }

    public static <V> EntityBuilder<V> entityBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getEntityTypeBuilder();
    }

    public static <V> BlockEntityBuilder<V> blockEntityBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getBlockEntityTypeBuilder();
    }

    public static <V> LevelChunkBuilder<V> levelChunkBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getLevelChunkBuilder();
    }

    public static <V> LevelBuilder<V> levelBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getLevelBuilder();
    }

    public static interface EntityBuilder<V>
    extends RegistryBuilder<Entity, V, EntityBuilder<V>> {
        @Override
        default public EntityBuilder<V> defaultValue(EntityType<?> entityType, V defaultValue) {
            return (EntityBuilder)this.defaultValue((T entity) -> entity.getType() == entityType, defaultValue);
        }

        public EntityBuilder<V> copyOnDeath();
    }

    public static interface BlockEntityBuilder<V>
    extends RegistryBuilder<BlockEntity, V, BlockEntityBuilder<V>> {
        @Override
        default public BlockEntityBuilder<V> defaultValue(BlockEntityType<?> blockEntityType, V defaultValue) {
            return (BlockEntityBuilder)this.defaultValue((T blockEntity) -> blockEntity.getType() == blockEntityType, defaultValue);
        }
    }

    public static interface LevelChunkBuilder<V>
    extends Builder<LevelChunk, V, LevelChunkBuilder<V>> {
    }

    public static interface LevelBuilder<V>
    extends Builder<Level, V, LevelBuilder<V>> {
    }

    public static interface RegistryBuilder<T, V, B extends RegistryBuilder<T, V, B>>
    extends Builder<T, V, B> {
        @Override
        default public B defaultValue(Function<RegistryAccess, V> defaultValueProvider) {
            return this.defaultValue((Predicate<T>)Predicates.alwaysTrue(), defaultValueProvider);
        }

        default public B defaultValue(Class<? extends T> holderType, V defaultValue) {
            return this.defaultValue(holderType::isInstance, defaultValue);
        }

        default public B defaultValue(Predicate<T> defaultFilter, V defaultValue) {
            return this.defaultValue(defaultFilter, registries -> defaultValue);
        }

        public B defaultValue(Predicate<T> var1, Function<RegistryAccess, V> var2);
    }

    public static interface Builder<T, V, B extends Builder<T, V, B>> {
        public B getThis();

        default public B defaultValue(V defaultValue) {
            return this.defaultValue(registries -> defaultValue);
        }

        public B defaultValue(Function<RegistryAccess, V> var1);

        public B persistent(Codec<V> var1);

        public B networkSynchronized(StreamCodec<? super RegistryFriendlyByteBuf, V> var1, Function<T, PlayerSet> var2);

        public DataAttachmentType<T, V> build(Identifier var1);
    }
}

