/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.block.v1;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public final class BlockConversionHelper {
    private BlockConversionHelper() {
    }

    public static BlockBehaviour.Properties copyBlockProperties(Block block, Identifier identifier) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block).overrideLootTable(block.getLootTable()).overrideDescription(block.getDescriptionId()).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)identifier));
    }

    public static void setBlockItemBlock(BlockItem item, Block block) {
        BlockConversionHelper.setItemForBlock(block, (Item)item);
        BlockConversionHelper.setBlockForItem(item, block);
    }

    public static void setItemForBlock(Block block, Item item) {
        Objects.requireNonNull(block, () -> "block " + (String)(item != null ? "for item '" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item)) + "' " : "") + "is null");
        Objects.requireNonNull(item, () -> "item for block '" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block)) + "' is null");
        Item.BY_BLOCK.put(block, item);
        block.item = item;
    }

    public static void setBlockForItem(BlockItem item, Block block) {
        Objects.requireNonNull(item, () -> "item " + (String)(block != null ? "for block '" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block)) + "' " : "") + "is null");
        Objects.requireNonNull(block, () -> "block for item '" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item)) + "' is null");
        Block oldBlock = item.getBlock();
        if (oldBlock != null) {
            oldBlock.item = item;
        }
        item.block = block;
    }

    public static void copyBoundTags(Block from, Block to) {
        Objects.requireNonNull(from, () -> "source " + (String)(to != null ? "for target '" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)to)) + "' " : "") + "is null");
        Objects.requireNonNull(to, () -> "target for source '" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)from)) + "' is null");
        Set fromTagKeys = from.builtInRegistryHolder().tags().collect(Collectors.toSet());
        Set toTagKeys = to.builtInRegistryHolder().tags().collect(Collectors.toSet());
        if (toTagKeys.isEmpty()) {
            to.builtInRegistryHolder().bindTags(fromTagKeys);
        } else if (!Objects.equals(fromTagKeys, toTagKeys)) {
            throw new IllegalStateException("Target block tags for " + String.valueOf(to.builtInRegistryHolder().key()) + " not empty: " + String.valueOf(toTagKeys));
        }
    }
}

