/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.particle.ParticleDescription;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jspecify.annotations.Nullable;

public abstract class AbstractParticleProvider
implements DataProvider {
    public static final Codec<ParticleDescription> CODEC = Identifier.CODEC.listOf().fieldOf("textures").xmap(ParticleDescription::new, ParticleDescription::getTextures).codec();
    private final Map<Identifier, ParticleDescription> values = new LinkedHashMap<Identifier, ParticleDescription>();
    private final PackOutput.PathProvider pathProvider;
    private final @Nullable ResourceManager clientResourceManager;

    public AbstractParticleProvider(DataProviderContext context) {
        this(context.getPackOutput(), context.getClientResourceManager());
    }

    public AbstractParticleProvider(PackOutput packOutput, @Nullable ResourceManager clientResourceManager) {
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "particles");
        this.clientResourceManager = clientResourceManager;
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        this.addParticles();
        return DataProvider.saveAll((CachedOutput)cachedOutput, CODEC, (PackOutput.PathProvider)this.pathProvider, this.values);
    }

    public abstract void addParticles();

    public void add(ParticleType<?> particleType) {
        this.add(particleType, -1);
    }

    public void add(ParticleType<?> particleType, int indexEnd) {
        this.add(particleType, BuiltInRegistries.PARTICLE_TYPE.getKey(particleType), indexEnd);
    }

    public void add(ParticleType<?> particleType, int indexStart, int indexEnd) {
        this.add(particleType, BuiltInRegistries.PARTICLE_TYPE.getKey(particleType), indexStart, indexEnd);
    }

    public void add(ParticleType<?> particleType, Identifier identifier, int indexEnd) {
        this.add(BuiltInRegistries.PARTICLE_TYPE.getKey(particleType), identifier, indexEnd);
    }

    public void add(ParticleType<?> particleType, Identifier identifier, int indexStart, int indexEnd) {
        this.add(BuiltInRegistries.PARTICLE_TYPE.getKey(particleType), identifier, indexStart, indexEnd);
    }

    public void add(Identifier id, Identifier identifier, int indexEnd) {
        this.add(id, identifier, 0, indexEnd);
    }

    public void add(Identifier id, Identifier identifier, int indexStart, int indexEnd) {
        if (indexEnd == -1) {
            this.add(id, new ParticleDescription(Collections.singletonList(identifier)));
        } else {
            List textures = IntStream.rangeClosed(Math.min(indexStart, indexEnd), Math.max(indexStart, indexEnd)).mapToObj(index -> Identifier.fromNamespaceAndPath((String)identifier.getNamespace(), (String)(identifier.getPath() + "_" + index))).collect(Collectors.toList());
            if (indexEnd < indexStart) {
                Collections.reverse(textures);
            }
            this.add(id, new ParticleDescription(textures));
        }
    }

    public void add(Identifier id, ParticleDescription particleDescription) {
        if (this.clientResourceManager != null) {
            this.validate(id, particleDescription, this.clientResourceManager);
        }
        if (this.values.putIfAbsent(id, particleDescription) != null) {
            throw new IllegalStateException("Duplicate particle description: " + String.valueOf(id));
        }
    }

    protected void validate(Identifier id, ParticleDescription particleDescription, ResourceManager resourceManager) {
        Objects.requireNonNull(resourceManager, "resource manager is null");
        List<String> missingTextures = particleDescription.getTextures().stream().filter(identifier -> resourceManager.getResource(identifier.withPath(string -> "textures/particle/" + string + ".png")).isEmpty()).map(Identifier::toString).toList();
        if (!missingTextures.isEmpty()) {
            throw new IllegalArgumentException("Couldn't define particle description %s as it is missing following texture(s): %s".formatted(id, String.join((CharSequence)",", missingTextures)));
        }
    }

    public String getName() {
        return "Particle Descriptions";
    }
}

