/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2.models;

import fuzs.puzzleslib.api.client.data.v2.models.ModelLocationHelper;
import fuzs.puzzleslib.api.client.data.v2.models.ModelTemplateHelper;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;

public final class ItemModelGenerationHelper {
    public static final ModelTemplate HORN = ModelTemplateHelper.createItemModelTemplate(Identifier.withDefaultNamespace((String)"goat_horn"), TextureSlot.LAYER0);
    public static final ModelTemplate TOOTING_HORN = ModelTemplateHelper.createItemModelTemplate(Identifier.withDefaultNamespace((String)"tooting_goat_horn"), TextureSlot.LAYER0);
    public static final ModelTemplate SHIELD_MODEL_TEMPLATE = ModelTemplateHelper.createItemModelTemplate(Identifier.withDefaultNamespace((String)"shield"), TextureSlot.PARTICLE);
    public static final ModelTemplate SHIELD_BLOCKING_MODEL_TEMPLATE = ModelTemplateHelper.createItemModelTemplate(Identifier.withDefaultNamespace((String)"shield_blocking"), TextureSlot.PARTICLE);

    private ItemModelGenerationHelper() {
    }

    public static void generateFlatItem(Item item, ModelTemplate modelTemplate, ItemModelGenerators itemModelGenerators) {
        itemModelGenerators.itemModelOutput.accept(item, ItemModelUtils.plainModel((Identifier)ItemModelGenerationHelper.createFlatItemModel(item, modelTemplate, (BiConsumer<Identifier, ModelInstance>)itemModelGenerators.modelOutput)));
    }

    public static Identifier createFlatItemModel(Item item, ModelTemplate modelTemplate, BiConsumer<Identifier, ModelInstance> modelOutput) {
        return ItemModelGenerationHelper.createFlatItemModel(item, item, modelTemplate, modelOutput);
    }

    public static void generateFlatItem(Item item, Item layerItem, ModelTemplate modelTemplate, ItemModelGenerators itemModelGenerators) {
        itemModelGenerators.itemModelOutput.accept(item, ItemModelUtils.plainModel((Identifier)ItemModelGenerationHelper.createFlatItemModel(item, layerItem, modelTemplate, (BiConsumer<Identifier, ModelInstance>)itemModelGenerators.modelOutput)));
    }

    public static Identifier createFlatItemModel(Item item, Item layerItem, ModelTemplate modelTemplate, BiConsumer<Identifier, ModelInstance> modelOutput) {
        return ItemModelGenerationHelper.createFlatItemModel(item, ModelLocationHelper.getItemModel(layerItem), modelTemplate, modelOutput);
    }

    public static void generateFlatItem(Item item, Identifier layer0Location, ModelTemplate modelTemplate, ItemModelGenerators itemModelGenerators) {
        itemModelGenerators.itemModelOutput.accept(item, ItemModelUtils.plainModel((Identifier)ItemModelGenerationHelper.createFlatItemModel(item, layer0Location, modelTemplate, (BiConsumer<Identifier, ModelInstance>)itemModelGenerators.modelOutput)));
    }

    public static Identifier createFlatItemModel(Item item, Identifier layer0Location, ModelTemplate modelTemplate, BiConsumer<Identifier, ModelInstance> modelOutput) {
        return ItemModelGenerationHelper.createFlatItemModel(ModelLocationHelper.getItemModel(item), layer0Location, modelTemplate, modelOutput);
    }

    public static Identifier createFlatItemModel(Identifier identifier, ModelTemplate modelTemplate, BiConsumer<Identifier, ModelInstance> modelOutput) {
        return ItemModelGenerationHelper.createFlatItemModel(identifier, identifier, modelTemplate, modelOutput);
    }

    public static Identifier createFlatItemModel(Identifier identifier, Identifier layer0Location, ModelTemplate modelTemplate, BiConsumer<Identifier, ModelInstance> modelOutput) {
        return modelTemplate.create(identifier, TextureMapping.layer0((Identifier)layer0Location), modelOutput);
    }

    public static void generateLayeredItem(Item item, Identifier layer0Location, Identifier layer1Location, ModelTemplate modelTemplate, ItemModelGenerators itemModelGenerators) {
        itemModelGenerators.itemModelOutput.accept(item, ItemModelUtils.plainModel((Identifier)ItemModelGenerationHelper.createLayeredItemModel(item, layer0Location, layer1Location, modelTemplate, (BiConsumer<Identifier, ModelInstance>)itemModelGenerators.modelOutput)));
    }

    public static Identifier createLayeredItemModel(Item item, Identifier layer0Location, Identifier layer1Location, ModelTemplate modelTemplate, BiConsumer<Identifier, ModelInstance> modelOutput) {
        return ItemModelGenerationHelper.createLayeredItemModel(ModelLocationHelper.getItemModel(item), layer0Location, layer1Location, modelTemplate, modelOutput);
    }

    public static Identifier createLayeredItemModel(Identifier identifier, Identifier layer0Location, Identifier layer1Location, ModelTemplate modelTemplate, BiConsumer<Identifier, ModelInstance> modelOutput) {
        return modelTemplate.create(identifier, TextureMapping.layered((Identifier)layer0Location, (Identifier)layer1Location), modelOutput);
    }

    public static void generateBow(Item item, ItemModelGenerators itemModelGenerators) {
        itemModelGenerators.createFlatItemModel(item, ModelTemplates.BOW);
        itemModelGenerators.generateBow(item);
    }

    public static void generateHorn(Item item, ItemModelGenerators itemModelGenerators) {
        ItemModel.Unbaked falseModel = ItemModelUtils.plainModel((Identifier)itemModelGenerators.createFlatItemModel(item, HORN));
        ItemModel.Unbaked trueModel = ItemModelUtils.plainModel((Identifier)ItemModelGenerationHelper.createFlatItemModel(ModelLocationHelper.getItemModel(item, "_tooting"), ModelLocationHelper.getItemModel(item), TOOTING_HORN, (BiConsumer<Identifier, ModelInstance>)itemModelGenerators.modelOutput));
        itemModelGenerators.generateBooleanDispatch(item, ItemModelUtils.isUsingItem(), trueModel, falseModel);
    }

    public static void generateHead(Block headBlock, Block wallHeadBlock, SkullBlock.Type type, BlockModelGenerators blockModelGenerators) {
        blockModelGenerators.createHead(headBlock, wallHeadBlock, type, ModelLocationUtils.decorateItemModelLocation((String)"template_skull"));
    }

    public static void generateShield(Item item, Block particleBlock, Supplier<SpecialModelRenderer.Unbaked> specialModelSupplier, ItemModelGenerators itemModelGenerators) {
        Identifier identifier = SHIELD_MODEL_TEMPLATE.create(ModelLocationHelper.getItemModel(item), TextureMapping.particle((Block)particleBlock), itemModelGenerators.modelOutput);
        Identifier identifier2 = SHIELD_BLOCKING_MODEL_TEMPLATE.create(ModelLocationHelper.getItemModel(item, "_blocking"), TextureMapping.particle((Block)particleBlock), itemModelGenerators.modelOutput);
        ItemModel.Unbaked unbaked = ItemModelUtils.specialModel((Identifier)identifier, (SpecialModelRenderer.Unbaked)specialModelSupplier.get());
        ItemModel.Unbaked unbaked2 = ItemModelUtils.specialModel((Identifier)identifier2, (SpecialModelRenderer.Unbaked)specialModelSupplier.get());
        itemModelGenerators.generateBooleanDispatch(item, ItemModelUtils.isUsingItem(), unbaked2, unbaked);
    }
}

