/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2.models;

import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class ModelLocationHelper {
    public static final String BLOCK_PATH = "block";
    public static final String ITEM_PATH = "item";

    private ModelLocationHelper() {
    }

    public static Identifier getBlockModel(Block block) {
        return ModelLocationUtils.getModelLocation((Block)block);
    }

    public static Identifier getBlockModel(Block block, String suffix) {
        return ModelLocationUtils.getModelLocation((Block)block, (String)suffix);
    }

    public static Identifier getBlockModel(Identifier identifier) {
        return identifier.withPrefix("block/");
    }

    public static Identifier getBlockModel(Identifier identifier, String suffix) {
        return ModelLocationHelper.getBlockModel(identifier).withSuffix(suffix);
    }

    public static Identifier getBlockTexture(Block block) {
        return TextureMapping.getBlockTexture((Block)block);
    }

    public static Identifier getBlockTexture(Block block, String suffix) {
        return TextureMapping.getBlockTexture((Block)block, (String)suffix);
    }

    public static Identifier getBlockTexture(Identifier identifier) {
        return identifier.withPrefix("block/");
    }

    public static Identifier getBlockTexture(Identifier identifier, String suffix) {
        return ModelLocationHelper.getBlockTexture(identifier).withSuffix(suffix);
    }

    public static Identifier getBlockLocation(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static Identifier getBlockLocation(Block block, String suffix) {
        return ModelLocationHelper.getBlockLocation(block).withSuffix(suffix);
    }

    public static String getBlockName(Block block) {
        return ModelLocationHelper.getBlockLocation(block).getPath();
    }

    public static Identifier getItemModel(Item item) {
        return ModelLocationUtils.getModelLocation((Item)item);
    }

    public static Identifier getItemModel(Item item, String suffix) {
        return ModelLocationUtils.getModelLocation((Item)item, (String)suffix);
    }

    public static Identifier getItemModel(Identifier identifier) {
        return identifier.withPrefix("item/");
    }

    public static Identifier getItemModel(Identifier identifier, String suffix) {
        return ModelLocationHelper.getItemModel(identifier).withSuffix(suffix);
    }

    public static Identifier getItemTexture(Item item) {
        return TextureMapping.getItemTexture((Item)item);
    }

    public static Identifier getItemTexture(Item item, String suffix) {
        return TextureMapping.getItemTexture((Item)item, (String)suffix);
    }

    public static Identifier getItemTexture(Identifier identifier) {
        return identifier.withPrefix("item/");
    }

    public static Identifier getItemTexture(Identifier identifier, String suffix) {
        return ModelLocationHelper.getItemTexture(identifier).withSuffix(suffix);
    }

    public static Identifier getItemLocation(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static Identifier getItemLocation(Item item, String suffix) {
        return ModelLocationHelper.getItemLocation(item).withSuffix(suffix);
    }

    public static String getItemName(Item item) {
        return ModelLocationHelper.getItemLocation(item).getPath();
    }
}

