/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import fuzs.puzzleslib.impl.client.gui.SingleTextureAtlasSprite;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public final class GuiGraphicsHelper {
    private GuiGraphicsHelper() {
    }

    public static void drawInBatch8xOutline(GuiGraphics guiGraphics, Font font, Component component, int posX, int posY, int color, int backgroundColor) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                guiGraphics.drawString(font, component, posX + i, posY + j, backgroundColor, false);
            }
        }
        guiGraphics.drawString(font, component, posX, posY, color, false);
    }

    public static void fillFrame(GuiGraphics guiGraphics, int posX, int posY, int width, int height, int borderSize, int color) {
        GuiGraphicsHelper.fillFrameArea(guiGraphics, posX, posY, posX + width, posY + height, borderSize, color);
    }

    public static void fillFrameArea(GuiGraphics guiGraphics, int minX, int minY, int maxX, int maxY, int borderSize, int color) {
        guiGraphics.fill(minX, minY, maxX, minY + borderSize, color);
        guiGraphics.fill(minX, maxY - borderSize, maxX, maxY, color);
        guiGraphics.fill(minX, minY + borderSize, minX + borderSize, maxY - borderSize, color);
        guiGraphics.fill(maxX - borderSize, minY + borderSize, maxX, maxY - borderSize, color);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier identifier, int x, int y, int width, int height, int borderSize, int spriteWidth, int spriteHeight, int uOffset, int vOffset) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, renderPipeline, identifier, x, y, width, height, borderSize, borderSize, spriteWidth, spriteHeight, uOffset, vOffset);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier identifier, int x, int y, int width, int height, int borderWidth, int borderHeight, int spriteWidth, int spriteHeight, int uOffset, int vOffset) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, renderPipeline, identifier, x, y, width, height, borderWidth, borderHeight, borderWidth, borderHeight, spriteWidth, spriteHeight, uOffset, vOffset);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier identifier, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom, int spriteWidth, int spriteHeight, int uOffset, int vOffset) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, renderPipeline, identifier, x, y, width, height, borderLeft, borderTop, borderRight, borderBottom, spriteWidth, spriteHeight, uOffset, vOffset, -1);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier identifier, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom, int spriteWidth, int spriteHeight, int uOffset, int vOffset, int color) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, renderPipeline, identifier, x, y, width, height, borderLeft, borderTop, borderRight, borderBottom, spriteWidth, spriteHeight, uOffset, vOffset, 256, 256, color);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier identifier, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom, int spriteWidth, int spriteHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, renderPipeline, identifier, x, y, width, height, borderLeft, borderTop, borderRight, borderBottom, spriteWidth, spriteHeight, uOffset, vOffset, textureWidth, textureHeight, -1);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier identifier, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom, int spriteWidth, int spriteHeight, int uOffset, int vOffset, int textureWidth, int textureHeight, int color) {
        SingleTextureAtlasSprite textureAtlasSprite = new SingleTextureAtlasSprite(identifier, spriteWidth, spriteHeight, uOffset, vOffset, textureWidth, textureHeight);
        GuiSpriteScaling.NineSlice nineSlice = new GuiSpriteScaling.NineSlice(spriteWidth, spriteHeight, new GuiSpriteScaling.NineSlice.Border(borderLeft, borderTop, borderRight, borderBottom), false);
        guiGraphics.blitNineSlicedSprite(renderPipeline, (TextureAtlasSprite)textureAtlasSprite, nineSlice, x, y, width, height, color);
    }

    public static void blitNineSlicedSprite(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier sprite, int x, int y, int width, int height, int borderSize) {
        GuiGraphicsHelper.blitNineSlicedSprite(guiGraphics, renderPipeline, sprite, x, y, width, height, borderSize, borderSize, borderSize, borderSize, -1);
    }

    public static void blitNineSlicedSprite(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier sprite, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom) {
        GuiGraphicsHelper.blitNineSlicedSprite(guiGraphics, renderPipeline, sprite, x, y, width, height, borderLeft, borderTop, borderRight, borderBottom, -1);
    }

    public static void blitNineSlicedSprite(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier sprite, int x, int y, int width, int height, int borderLeft, int borderTop, int borderRight, int borderBottom, int color) {
        TextureAtlasSprite textureAtlasSprite = guiGraphics.getSprite(new Material(Sheets.GUI_SHEET, sprite));
        GuiSpriteScaling.NineSlice nineSlice = new GuiSpriteScaling.NineSlice(textureAtlasSprite.contents().width(), textureAtlasSprite.contents().height(), new GuiSpriteScaling.NineSlice.Border(borderLeft, borderTop, borderRight, borderBottom), false);
        guiGraphics.blitNineSlicedSprite(renderPipeline, textureAtlasSprite, nineSlice, x, y, width, height, color);
    }

    public static void blitTiledSprite(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier sprite, int x, int y, int width, int height, int spriteWidth, int spriteHeight) {
        GuiGraphicsHelper.blitTiledSprite(guiGraphics, renderPipeline, sprite, x, y, width, height, spriteWidth, spriteHeight, -1);
    }

    public static void blitTiledSprite(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier sprite, int x, int y, int width, int height, int spriteWidth, int spriteHeight, int color) {
        GuiGraphicsHelper.blitTiledSprite(guiGraphics, renderPipeline, sprite, x, y, width, height, spriteWidth, spriteHeight, 0, 0, color);
    }

    public static void blitTiledSprite(GuiGraphics guiGraphics, RenderPipeline renderPipeline, Identifier sprite, int x, int y, int width, int height, int spriteWidth, int spriteHeight, int uOffset, int vOffset, int color) {
        TextureAtlasSprite textureAtlasSprite = guiGraphics.getSprite(new Material(Sheets.GUI_SHEET, sprite));
        guiGraphics.blitTiledSprite(renderPipeline, textureAtlasSprite, x, y, width, height, uOffset, vOffset, spriteWidth, spriteHeight, spriteWidth, spriteHeight, color);
    }
}

