/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2;

import fuzs.puzzleslib.impl.client.core.proxy.ClientProxyImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;
import net.minecraft.world.effect.MobEffectInstance;

public final class ScreenHelper {
    private ScreenHelper() {
    }

    public static float getPartialTick() {
        return Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(false);
    }

    public static int getMouseX() {
        Minecraft minecraft = Minecraft.getInstance();
        return (int)(minecraft.mouseHandler.xpos() * (double)minecraft.getWindow().getGuiScaledWidth() / (double)minecraft.getWindow().getScreenWidth());
    }

    public static int getMouseY() {
        Minecraft minecraft = Minecraft.getInstance();
        return (int)(minecraft.mouseHandler.ypos() * (double)minecraft.getWindow().getGuiScaledHeight() / (double)minecraft.getWindow().getScreenHeight());
    }

    public static boolean isDoubleClick(MouseButtonEvent mouseButtonEvent) {
        MouseHandler mouseHandler = Minecraft.getInstance().mouseHandler;
        if (mouseHandler.lastClick == null) {
            return false;
        }
        if (mouseHandler.lastClick.screen() != Minecraft.getInstance().screen) {
            return false;
        }
        if (mouseHandler.lastClickButton != mouseButtonEvent.button()) {
            return false;
        }
        return Util.getMillis() - mouseHandler.lastClick.time() < 250L;
    }

    public static boolean isHovering(int posX, int posY, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)posX && mouseX < (double)(posX + width) && mouseY >= (double)posY && mouseY < (double)(posY + height);
    }

    public static int getLeftStatusBarHeight(Identifier identifier) {
        return ClientProxyImpl.get().getLeftStatusBarHeight(identifier);
    }

    public static int getRightStatusBarHeight(Identifier identifier) {
        return ClientProxyImpl.get().getRightStatusBarHeight(identifier);
    }

    public static boolean isEffectVisibleInInventory(MobEffectInstance mobEffect) {
        return ClientProxyImpl.get().isEffectVisibleInInventory(mobEffect);
    }

    public static boolean isEffectVisibleInGui(MobEffectInstance mobEffect) {
        return ClientProxyImpl.get().isEffectVisibleInGui(mobEffect);
    }
}

