/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.tooltip;

import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.impl.client.core.proxy.ClientProxyImpl;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jspecify.annotations.Nullable;

public final class TooltipRenderHelper {
    private TooltipRenderHelper() {
    }

    public static List<Component> getTooltipLines(ItemStack itemStack) {
        return TooltipRenderHelper.getTooltipLines(itemStack, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }

    public static List<Component> getTooltipLines(ItemStack itemStack, TooltipFlag tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        Minecraft minecraft = Minecraft.getInstance();
        return itemStack.getTooltipLines(Item.TooltipContext.of((Level)minecraft.level), (Player)minecraft.player, tooltipFlag);
    }

    public static List<ClientTooltipComponent> getTooltip(ItemStack itemStack) {
        return TooltipRenderHelper.getTooltip(itemStack, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }

    public static List<ClientTooltipComponent> getTooltip(ItemStack itemStack, TooltipFlag tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        List<Component> components = TooltipRenderHelper.getTooltipLines(itemStack, tooltipFlag);
        List<TooltipComponent> imageComponents = itemStack.getTooltipImage().map(List::of).orElse(List.of());
        return TooltipRenderHelper.createClientComponents(components, imageComponents);
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, ItemStack itemStack) {
        Objects.requireNonNull(itemStack, "item stack is null");
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, TooltipRenderHelper.getTooltip(itemStack));
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, Component component, TooltipComponent imageComponent) {
        Objects.requireNonNull(component, "component is null");
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, List.of(component), imageComponent);
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, List<Component> components, TooltipComponent imageComponent) {
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of(imageComponent));
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, List<Component> components) {
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of());
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, List<Component> components, List<TooltipComponent> imageComponents) {
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, TooltipRenderHelper.createClientComponents(components, imageComponents));
    }

    public static List<ClientTooltipComponent> createClientComponents(List<Component> components, List<TooltipComponent> imageComponents) {
        return TooltipRenderHelper.createClientComponents(components, imageComponents, 1);
    }

    public static List<ClientTooltipComponent> createClientComponents(List<Component> components, List<TooltipComponent> imageComponents, int insertAt) {
        List clientComponents = components.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).collect(Collectors.toList());
        List<ClientTooltipComponent> clientImageComponents = imageComponents.stream().map(TooltipRenderHelper::createImageComponent).toList();
        if (insertAt == -1) {
            clientComponents.addAll(clientImageComponents);
        } else {
            clientComponents.addAll(Math.min(clientComponents.size(), insertAt), clientImageComponents);
        }
        return ImmutableList.copyOf(clientComponents);
    }

    public static ClientTooltipComponent createImageComponent(TooltipComponent imageComponent) {
        return ClientProxyImpl.get().createImageComponent(imageComponent);
    }

    public static void renderTooltipComponents(GuiGraphics guiGraphics, int posX, int posY, List<? extends ClientTooltipComponent> tooltipComponents) {
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, tooltipComponents, null);
    }

    public static void renderTooltipComponents(GuiGraphics guiGraphics, int posX, int posY, List<? extends ClientTooltipComponent> tooltipComponents, @Nullable Identifier tooltipStyle) {
        ClientTooltipComponent component;
        int i;
        Font font = Minecraft.getInstance().font;
        if (tooltipComponents.isEmpty() || TooltipRenderHelper.onRenderTooltip(guiGraphics, font, posX, posY, tooltipComponents, DefaultTooltipPositioner.INSTANCE)) {
            return;
        }
        int lineWidth = 0;
        int lineHeight = tooltipComponents.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent component2 : tooltipComponents) {
            int width = component2.getWidth(font);
            if (width > lineWidth) {
                lineWidth = width;
            }
            lineHeight += component2.getHeight(font);
        }
        int originPosX = posX + 12;
        int originPosY = posY - 12;
        guiGraphics.pose().pushMatrix();
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)originPosX, (int)originPosY, (int)lineWidth, (int)lineHeight, (Identifier)tooltipStyle);
        MutableInt currentPosY = new MutableInt(originPosY);
        for (i = 0; i < tooltipComponents.size(); ++i) {
            component = tooltipComponents.get(i);
            component.renderText(guiGraphics, font, originPosX, currentPosY.intValue());
            currentPosY.add(component.getHeight(font) + (i == 0 ? 2 : 0));
        }
        currentPosY.setValue(originPosY);
        for (i = 0; i < tooltipComponents.size(); ++i) {
            component = tooltipComponents.get(i);
            component.renderImage(font, originPosX, currentPosY.intValue(), lineWidth, lineHeight, guiGraphics);
            currentPosY.add(component.getHeight(font) + (i == 0 ? 2 : 0));
        }
        guiGraphics.pose().popMatrix();
    }

    public static boolean onRenderTooltip(GuiGraphics guiGraphics, Font font, int mouseX, int mouseY, List<ClientTooltipComponent> components, ClientTooltipPositioner positioner) {
        return ClientProxyImpl.get().onRenderTooltip(guiGraphics, font, mouseX, mouseY, components, positioner);
    }
}

