/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.init.v1;

import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.state.properties.WoodType;

@FunctionalInterface
public interface ModelLayerFactory {
    public static ModelLayerFactory from(String modId) {
        return () -> modId;
    }

    public String modId();

    default public ModelLayerLocation registerModelLayer(String path, String layer) {
        ModelLayerLocation modelLayerLocation = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)this.modId(), (String)path), layer);
        if (!ModelLayers.ALL_MODELS.add(modelLayerLocation)) {
            throw new IllegalStateException("Duplicate registration for " + String.valueOf(modelLayerLocation));
        }
        return modelLayerLocation;
    }

    default public ModelLayerLocation registerModelLayer(String path) {
        return this.registerModelLayer(path, "main");
    }

    default public ArmorModelSet<ModelLayerLocation> registerArmorSet(String path) {
        return new ArmorModelSet((Object)this.registerModelLayer(path, "helmet"), (Object)this.registerModelLayer(path, "chestplate"), (Object)this.registerModelLayer(path, "leggings"), (Object)this.registerModelLayer(path, "boots"));
    }

    default public ModelLayerLocation createStandingSignModelName(WoodType woodType) {
        return this.registerModelLayer("sign/standing/" + woodType.name());
    }

    default public ModelLayerLocation createWallSignModelName(WoodType woodType) {
        return this.registerModelLayer("sign/wall/" + woodType.name());
    }

    default public ModelLayerLocation createHangingSignModelName(WoodType woodType, HangingSignRenderer.AttachmentType attachmentType) {
        return this.registerModelLayer("hanging_sign/" + woodType.name() + "/" + attachmentType.getSerializedName());
    }
}

