/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.util.v1;

import com.mojang.serialization.DynamicOps;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.world.level.LevelHeightAccessor;
import org.jspecify.annotations.Nullable;

public final class ClientParticleHelper {
    private ClientParticleHelper() {
    }

    public static @Nullable Particle addParticle(ClientLevel clientLevel, ParticleOptions particleOptions, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return ClientParticleHelper.addParticle(clientLevel, particleOptions, particleOptions.getType().getOverrideLimiter(), false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public static @Nullable Particle addParticle(ClientLevel clientLevel, ParticleOptions particleOptions, boolean forceAlwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return ClientParticleHelper.addParticle(clientLevel, particleOptions, particleOptions.getType().getOverrideLimiter() || forceAlwaysRender, false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public static @Nullable Particle addAlwaysVisibleParticle(ClientLevel clientLevel, ParticleOptions particleOptions, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return ClientParticleHelper.addParticle(clientLevel, particleOptions, false, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public static @Nullable Particle addAlwaysVisibleParticle(ClientLevel clientLevel, ParticleOptions particleOptions, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return ClientParticleHelper.addParticle(clientLevel, particleOptions, particleOptions.getType().getOverrideLimiter() || ignoreRange, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public static @Nullable Particle addParticle(ClientLevel clientLevel, ParticleOptions particleOptions, boolean force, boolean decreased, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        try {
            Camera camera = clientLevel.minecraft.gameRenderer.getMainCamera();
            ParticleStatus particleStatus = clientLevel.calculateParticleLevel(decreased);
            if (force) {
                return clientLevel.minecraft.particleEngine.createParticle(particleOptions, x, y, z, xSpeed, ySpeed, zSpeed);
            }
            if (!(camera.position().distanceToSqr(x, y, z) > 1024.0) && particleStatus != ParticleStatus.MINIMAL) {
                return clientLevel.minecraft.particleEngine.createParticle(particleOptions, x, y, z, xSpeed, ySpeed, zSpeed);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)"Exception while adding particle");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Particle being added");
            crashReportCategory.setDetail("ID", (Object)BuiltInRegistries.PARTICLE_TYPE.getKey((Object)particleOptions.getType()));
            crashReportCategory.setDetail("Parameters", () -> ParticleTypes.CODEC.encodeStart((DynamicOps)clientLevel.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)particleOptions).toString());
            crashReportCategory.setDetail("Position", () -> CrashReportCategory.formatLocation((LevelHeightAccessor)clientLevel, (double)x, (double)y, (double)z));
            throw new ReportedException(crashReport);
        }
        return null;
    }
}

