/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.NonInteractiveResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class ContainerMenuHelper {
    private ContainerMenuHelper() {
    }

    public static <T> void openMenu(Player player, MenuProvider menuProvider, T data) {
        Objects.requireNonNull(player, "player is null");
        Objects.requireNonNull(menuProvider, "menu provider is null");
        Objects.requireNonNull(data, "data is null");
        ProxyImpl.get().openMenu(player, menuProvider, data);
    }

    public static void setSelectedSlotLocked(AbstractContainerMenu containerMenu) {
        for (int i = 0; i < containerMenu.slots.size(); ++i) {
            Inventory inventory;
            Slot slot = (Slot)containerMenu.slots.get(i);
            Container container = slot.container;
            if (!(container instanceof Inventory) || (inventory = (Inventory)container).getSelectedSlot() != slot.getContainerSlot()) continue;
            NonInteractiveResultSlot newSlot = new NonInteractiveResultSlot(slot.container, slot.getContainerSlot(), slot.x, slot.y){

                public boolean isFake() {
                    return false;
                }
            };
            newSlot.index = slot.index;
            containerMenu.slots.set(i, (Object)newSlot);
            break;
        }
    }

    public static SimpleContainer createListBackedContainer(NonNullList<ItemStack> items, @Nullable Container container) {
        return ContainerMenuHelper.createListBackedContainer(items, container != null ? containerX -> container.setChanged() : null);
    }

    public static SimpleContainer createListBackedContainer(NonNullList<ItemStack> items, @Nullable ContainerListener listener) {
        SimpleContainer simpleContainer = new SimpleContainer(new ItemStack[0]);
        simpleContainer.size = items.size();
        simpleContainer.items = items;
        if (listener != null) {
            simpleContainer.addListener(listener);
        }
        return simpleContainer;
    }

    public static void copyItemsIntoContainer(NonNullList<ItemStack> from, Container to) {
        for (int i = 0; i < from.size(); ++i) {
            if (i >= to.getContainerSize()) continue;
            to.setItem(i, (ItemStack)from.get(i));
        }
    }

    public static void copyItemsIntoList(NonNullList<ItemStack> from, NonNullList<ItemStack> to) {
        for (int i = 0; i < from.size(); ++i) {
            if (i >= to.size()) continue;
            to.set(i, (Object)((ItemStack)from.get(i)));
        }
    }
}

