/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.DataPackRegistriesContext;
import fuzs.puzzleslib.api.core.v1.context.DataPackReloadListenersContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesContext;
import fuzs.puzzleslib.api.core.v1.context.GameRegistriesContext;
import fuzs.puzzleslib.api.core.v1.context.GameplayContentContext;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.core.v1.context.PayloadTypesContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.core.v1.context.VillagerTradesContext;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.core.context.ModConstructorImpl;
import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import java.util.function.Supplier;
import net.minecraft.resources.Identifier;

public interface ModConstructor {
    public static void construct(String modId, Supplier<ModConstructor> modConstructorSupplier) {
        ModConstructor.construct(Identifier.fromNamespaceAndPath((String)modId, (String)"common"), modConstructorSupplier);
    }

    public static void construct(Identifier identifier, Supplier<ModConstructor> modConstructorSupplier) {
        ModConstructorImpl.construct(identifier, modConstructorSupplier, ProxyImpl.get()::getModConstructorImpl, ModContext::runBeforeConstruction);
    }

    default public void onConstructMod() {
    }

    default public void onCommonSetup() {
    }

    default public void onRegisterPayloadTypes(PayloadTypesContext context) {
    }

    default public void onRegisterEntityAttributes(EntityAttributesContext context) {
    }

    default public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
    }

    default public void onRegisterBiomeModifications(BiomeModificationsContext context) {
    }

    default public void onRegisterGameplayContent(GameplayContentContext context) {
    }

    default public void onAddDataPackFinders(PackRepositorySourcesContext context) {
    }

    default public void onRegisterGameRegistries(GameRegistriesContext context) {
    }

    default public void onRegisterDataPackRegistries(DataPackRegistriesContext context) {
    }

    default public void onRegisterVillagerTrades(VillagerTradesContext context) {
    }

    default public void onAddDataPackReloadListeners(DataPackReloadListenersContext context) {
    }
}

