/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2.tags;

import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.data.v2.tags.AbstractTagAppender;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import fuzs.puzzleslib.impl.data.SortingTagBuilder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractTagProvider<T>
extends TagsProvider<T> {
    protected final String modId;

    public AbstractTagProvider(ResourceKey<? extends Registry<T>> registryKey, DataProviderContext context) {
        this(registryKey, context.getModId(), context.getPackOutput(), context.getRegistries());
    }

    public AbstractTagProvider(ResourceKey<? extends Registry<T>> registryKey, String modId, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registryKey, registries);
        this.modId = modId;
    }

    public abstract void addTags(HolderLookup.Provider var1);

    protected TagBuilder getOrCreateRawBuilder(TagKey<T> tagKey) {
        return this.builders.computeIfAbsent(tagKey.location(), identifier -> new SortingTagBuilder());
    }

    public AbstractTagAppender<T> tag(String string) {
        return this.tag(Identifier.parse((String)string));
    }

    public AbstractTagAppender<T> tag(Identifier identifier) {
        return this.tag(TagKey.create((ResourceKey)this.registryKey, (Identifier)identifier));
    }

    public AbstractTagAppender<T> tag(TagKey<T> tagKey) {
        return AbstractTagProvider.createTagAppender(this.getOrCreateRawBuilder(tagKey), this.registryKey);
    }

    @ApiStatus.Internal
    public static <T> AbstractTagAppender<T> createTagAppender(TagBuilder tagBuilder, ResourceKey<? extends Registry<? super T>> registryKey) {
        Optional optional = LookupHelper.getRegistry(registryKey);
        Function<Object, ResourceKey> keyExtractor = optional.isPresent() ? t -> (ResourceKey)optional.flatMap(registry -> registry.getResourceKey(t)).orElseThrow(() -> new IllegalStateException("Missing value in " + String.valueOf(registryKey) + ": " + String.valueOf(t))) : null;
        return ProxyImpl.get().getTagAppender(tagBuilder, keyExtractor);
    }
}

