/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.event.v1.core;

import fuzs.puzzleslib.impl.PuzzlesLibMod;
import fuzs.puzzleslib.impl.event.core.EventPhaseImpl;
import java.util.function.BiConsumer;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface EventPhase {
    public static final EventPhase DEFAULT = new EventPhaseImpl(Identifier.fromNamespaceAndPath((String)"fabric", (String)"default"), null, null);
    public static final EventPhase BEFORE = new EventPhaseImpl(PuzzlesLibMod.id("before"), DEFAULT, EventPhaseImpl.Ordering.BEFORE);
    public static final EventPhase AFTER = new EventPhaseImpl(PuzzlesLibMod.id("after"), DEFAULT, EventPhaseImpl.Ordering.AFTER);
    public static final EventPhase FIRST = new EventPhaseImpl(PuzzlesLibMod.id("first"), BEFORE, EventPhaseImpl.Ordering.BEFORE);
    public static final EventPhase LAST = new EventPhaseImpl(PuzzlesLibMod.id("last"), AFTER, EventPhaseImpl.Ordering.AFTER);

    public Identifier identifier();

    public EventPhase parent();

    default public void applyOrdering(BiConsumer<Identifier, Identifier> phaseOrderingConsumer) {
        this.applyOrdering(this.identifier(), phaseOrderingConsumer);
    }

    public void applyOrdering(Identifier var1, BiConsumer<Identifier, Identifier> var2);

    public int getOrderingValue();

    public static EventPhase early(EventPhase eventPhase) {
        return new EventPhaseImpl(PuzzlesLibMod.id("early_" + eventPhase.identifier().getPath()), eventPhase, EventPhaseImpl.Ordering.BEFORE);
    }

    public static EventPhase late(EventPhase eventPhase) {
        return new EventPhaseImpl(PuzzlesLibMod.id("late_" + eventPhase.identifier().getPath()), eventPhase, EventPhaseImpl.Ordering.AFTER);
    }
}

