/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.registry;

import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.CommonSetupCallback;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import fuzs.puzzleslib.impl.item.CustomTransmuteRecipe;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public final class ContentRegistrationHelper {
    private ContentRegistrationHelper() {
    }

    public static void registerTransmuteRecipeSerializers(RegistryManager registryManager) {
        CustomTransmuteRecipe.registerSerializers((string, recipeSerializerSupplier) -> registryManager.register(Registries.RECIPE_SERIALIZER, (String)string, recipeSerializerSupplier));
    }

    public static SkullBlock.Type registerSkullBlockType(Identifier identifier) {
        String string = identifier.toString();
        SkullBlock.Type skullBlockType = () -> string;
        CommonSetupCallback.EVENT.register(() -> SkullBlock.Type.TYPES.put(skullBlockType.getSerializedName(), skullBlockType));
        return skullBlockType;
    }

    public static ContextKeySet registerContextKeySet(Identifier identifier, Consumer<ContextKeySet.Builder> builderConsumer) {
        ContextKeySet.Builder builder = new ContextKeySet.Builder();
        builderConsumer.accept(builder);
        ContextKeySet contextKeySet = builder.build();
        if (ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            ContentRegistrationHelper.registerContextKeySet(identifier, contextKeySet);
        } else {
            CommonSetupCallback.EVENT.register(() -> ContentRegistrationHelper.registerContextKeySet(identifier, contextKeySet));
        }
        return contextKeySet;
    }

    private static void registerContextKeySet(Identifier identifier, ContextKeySet contextKeySet) {
        if (LootContextParamSets.REGISTRY.put((Object)identifier, (Object)contextKeySet) != null) {
            throw new IllegalStateException("Loot context key set " + String.valueOf(identifier) + " is already registered");
        }
    }
}

