/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.GiveCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public final class GiveItemHelper {
    private GiveItemHelper() {
    }

    public static void giveItem(ItemStack itemStack, ServerPlayer serverPlayer) {
        GiveItemHelper.giveItem(itemStack, Collections.singleton(serverPlayer));
    }

    public static void giveItem(ItemStack itemStack, Collection<ServerPlayer> serverPlayers) {
        ServerPlayer serverPlayer = serverPlayers.iterator().next();
        GiveItemHelper.giveItem(GiveItemHelper.createTemporaryCommandSource(serverPlayer.level()), itemStack, serverPlayers);
    }

    private static void giveItem(CommandSourceStack commandSourceStack, ItemStack itemStack, Collection<ServerPlayer> serverPlayers) {
        try {
            ItemInput itemInput = new ItemInput(itemStack.getItemHolder(), itemStack.getComponentsPatch());
            GiveCommand.giveItem((CommandSourceStack)commandSourceStack, (ItemInput)itemInput, serverPlayers, (int)itemStack.getCount());
        }
        catch (CommandSyntaxException exception) {
            PuzzlesLib.LOGGER.warn("Failed to give {} to players {}", new Object[]{itemStack, serverPlayers, exception});
        }
    }

    private static CommandSourceStack createTemporaryCommandSource(ServerLevel serverLevel) {
        return new CommandSourceStack(CommandSource.NULL, Vec3.ZERO, Vec2.ZERO, serverLevel, (PermissionSet)LevelBasedPermissionSet.GAMEMASTER, "Empty", (Component)Component.literal((String)"Empty"), serverLevel.getServer(), null).withSuppressedOutput();
    }
}

