/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public interface ToolTypeHelper {
    public static final ToolTypeHelper INSTANCE = ProxyImpl.get().getToolTypeHelper();

    @MustBeInvokedByOverriders
    default public boolean isSword(ItemStack itemStack) {
        return itemStack.is(ItemTags.SWORDS);
    }

    @MustBeInvokedByOverriders
    default public boolean isAxe(ItemStack itemStack) {
        return itemStack.getItem() instanceof AxeItem || itemStack.is(ItemTags.AXES);
    }

    @MustBeInvokedByOverriders
    default public boolean isHoe(ItemStack itemStack) {
        return itemStack.getItem() instanceof HoeItem || itemStack.is(ItemTags.HOES);
    }

    @MustBeInvokedByOverriders
    default public boolean isPickaxe(ItemStack itemStack) {
        return itemStack.is(ItemTags.PICKAXES);
    }

    @MustBeInvokedByOverriders
    default public boolean isShovel(ItemStack itemStack) {
        return itemStack.getItem() instanceof AxeItem || itemStack.is(ItemTags.SHOVELS);
    }

    @MustBeInvokedByOverriders
    default public boolean isShears(ItemStack itemStack) {
        return itemStack.getItem() instanceof ShearsItem;
    }

    @MustBeInvokedByOverriders
    default public boolean isShield(ItemStack itemStack) {
        return itemStack.getItem() instanceof ShieldItem;
    }

    @MustBeInvokedByOverriders
    default public boolean isBow(ItemStack itemStack) {
        return itemStack.getItem() instanceof BowItem;
    }

    @MustBeInvokedByOverriders
    default public boolean isCrossbow(ItemStack itemStack) {
        return itemStack.getItem() instanceof CrossbowItem;
    }

    @MustBeInvokedByOverriders
    default public boolean isFishingRod(ItemStack itemStack) {
        return itemStack.getItem() instanceof FishingRodItem;
    }

    @MustBeInvokedByOverriders
    default public boolean isTridentLike(ItemStack itemStack) {
        return itemStack.getItem() instanceof TridentItem;
    }

    @MustBeInvokedByOverriders
    default public boolean isBrush(ItemStack itemStack) {
        return itemStack.getItem() instanceof BrushItem;
    }

    @MustBeInvokedByOverriders
    default public boolean isMace(ItemStack itemStack) {
        return itemStack.getItem() instanceof MaceItem;
    }

    @MustBeInvokedByOverriders
    default public boolean isSpear(ItemStack itemStack) {
        return itemStack.is(ItemTags.SPEARS);
    }

    @MustBeInvokedByOverriders
    default public boolean isMeleeWeapon(ItemStack itemStack) {
        return this.isSword(itemStack) || this.isAxe(itemStack) || this.isTridentLike(itemStack) || this.isMace(itemStack) || this.isSpear(itemStack);
    }

    @MustBeInvokedByOverriders
    default public boolean isRangedWeapon(ItemStack itemStack) {
        return this.isBow(itemStack) || this.isCrossbow(itemStack) || this.isTridentLike(itemStack);
    }

    @MustBeInvokedByOverriders
    default public boolean isWeapon(ItemStack itemStack) {
        return this.isMeleeWeapon(itemStack) || this.isRangedWeapon(itemStack);
    }

    @MustBeInvokedByOverriders
    default public boolean isMiningTool(ItemStack itemStack) {
        return this.isAxe(itemStack) || this.isHoe(itemStack) || this.isPickaxe(itemStack) || this.isShovel(itemStack);
    }

    @MustBeInvokedByOverriders
    default public boolean isTool(ItemStack itemStack) {
        return this.isMiningTool(itemStack) || this.isWeapon(itemStack) || this.isShears(itemStack) || this.isShield(itemStack) || this.isFishingRod(itemStack) || this.isBrush(itemStack);
    }

    @MustBeInvokedByOverriders
    default public boolean isHeadArmor(ItemStack itemStack) {
        return this.isArmor(itemStack, ArmorType.HELMET) || itemStack.is(ItemTags.HEAD_ARMOR);
    }

    @MustBeInvokedByOverriders
    default public boolean isChestArmor(ItemStack itemStack) {
        return this.isArmor(itemStack, ArmorType.CHESTPLATE) || itemStack.is(ItemTags.CHEST_ARMOR);
    }

    @MustBeInvokedByOverriders
    default public boolean isLegArmor(ItemStack itemStack) {
        return this.isArmor(itemStack, ArmorType.LEGGINGS) || itemStack.is(ItemTags.LEG_ARMOR);
    }

    @MustBeInvokedByOverriders
    default public boolean isFootArmor(ItemStack itemStack) {
        return this.isArmor(itemStack, ArmorType.BOOTS) || itemStack.is(ItemTags.FOOT_ARMOR);
    }

    @MustBeInvokedByOverriders
    default public boolean isBodyArmor(ItemStack itemStack) {
        return this.isArmor(itemStack, ArmorType.BODY);
    }

    @MustBeInvokedByOverriders
    private boolean isArmor(ItemStack itemStack, ArmorType armorType) {
        Equippable equippable = (Equippable)itemStack.get(DataComponents.EQUIPPABLE);
        return equippable != null && equippable.slot() == armorType.getSlot();
    }

    @MustBeInvokedByOverriders
    default public boolean isArmor(ItemStack itemStack) {
        return this.isHeadArmor(itemStack) || this.isChestArmor(itemStack) || this.isLegArmor(itemStack) || this.isFootArmor(itemStack) || this.isBodyArmor(itemStack);
    }
}

