/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v4;

import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface PlayerSet {
    public void apply(Consumer<ServerPlayer> var1);

    public static PlayerSet ofNone() {
        return serverPlayerConsumer -> {};
    }

    public static PlayerSet ofEntity(Entity entity) {
        Objects.requireNonNull(entity, "entity is null");
        return serverPlayerConsumer -> {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer);
            }
        };
    }

    public static PlayerSet ofPlayer(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return serverPlayerConsumer -> {
            if (serverPlayer.connection != null) {
                serverPlayerConsumer.accept(serverPlayer);
            } else {
                PuzzlesLib.LOGGER.warn("{} has not yet been fully initialized and is therefore unable to receive any packets", (Object)serverPlayer.getPlainTextName());
            }
        };
    }

    public static PlayerSet nearEntity(Entity entity) {
        Objects.requireNonNull(entity, "entity is null");
        return serverPlayerConsumer -> {
            Level patt0$temp = entity.level();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                ChunkMap chunkMap = serverLevel.getChunkSource().chunkMap;
                ChunkMap.TrackedEntity trackedEntity = (ChunkMap.TrackedEntity)chunkMap.entityMap.get(entity.getId());
                if (trackedEntity != null) {
                    for (ServerPlayerConnection serverPlayerConnection : trackedEntity.seenBy) {
                        PlayerSet.ofPlayer(serverPlayerConnection.getPlayer()).apply(serverPlayerConsumer);
                    }
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer);
                    }
                }
            }
        };
    }

    public static PlayerSet nearPlayer(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return serverPlayerConsumer -> {
            ChunkMap chunkMap = serverPlayer.level().getChunkSource().chunkMap;
            ChunkMap.TrackedEntity trackedEntity = (ChunkMap.TrackedEntity)chunkMap.entityMap.get(serverPlayer.getId());
            if (trackedEntity != null) {
                for (ServerPlayerConnection serverPlayerConnection : trackedEntity.seenBy) {
                    PlayerSet.ofPlayer(serverPlayerConnection.getPlayer()).apply(serverPlayerConsumer);
                }
            }
        };
    }

    public static PlayerSet ofOthers(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return serverPlayerConsumer -> serverPlayer.level().getServer().getPlayerList().getPlayers().forEach(currentServerPlayer -> {
            if (currentServerPlayer != serverPlayer) {
                PlayerSet.ofPlayer(currentServerPlayer).apply(serverPlayerConsumer);
            }
        });
    }

    public static PlayerSet ofAll(MinecraftServer minecraftServer) {
        return serverPlayerConsumer -> minecraftServer.getPlayerList().getPlayers().forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer));
    }

    public static PlayerSet inLevel(Level level) {
        Objects.requireNonNull(level, "level is null");
        return serverPlayerConsumer -> {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PlayerSet.inLevel(serverLevel).apply(serverPlayerConsumer);
            }
        };
    }

    public static PlayerSet inLevel(ServerLevel serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return serverPlayerConsumer -> {
            for (ServerPlayer serverPlayer : serverLevel.players()) {
                PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer);
            }
        };
    }

    public static PlayerSet nearPosition(Vec3i position, ServerLevel serverLevel) {
        Objects.requireNonNull(position, "position is null");
        return PlayerSet.nearPosition(position.getX(), position.getY(), position.getZ(), serverLevel);
    }

    public static PlayerSet nearPosition(double posX, double posY, double posZ, ServerLevel serverLevel) {
        return PlayerSet.nearPosition(null, posX, posY, posZ, 64.0, serverLevel);
    }

    public static PlayerSet nearPosition(@Nullable ServerPlayer excludePlayer, double posX, double posY, double posZ, double distance, ServerLevel serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return serverPlayerConsumer -> {
            for (ServerPlayer serverPlayer : serverLevel.getServer().getPlayerList().getPlayers()) {
                double deltaZ;
                double deltaY;
                double deltaX;
                if (serverPlayer == excludePlayer || serverPlayer.level().dimension() != serverLevel.dimension() || !((deltaX = posX - serverPlayer.getX()) * deltaX + (deltaY = posY - serverPlayer.getY()) * deltaY + (deltaZ = posZ - serverPlayer.getZ()) * deltaZ < distance * distance)) continue;
                PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer);
            }
        };
    }

    public static PlayerSet nearBlockEntity(BlockEntity blockEntity) {
        Objects.requireNonNull(blockEntity, "block entity is null");
        return serverPlayerConsumer -> {
            Level patt0$temp = blockEntity.getLevel();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                PlayerSet.nearPosition((Vec3i)blockEntity.getBlockPos(), serverLevel).apply(serverPlayerConsumer);
            }
        };
    }

    public static PlayerSet nearChunk(LevelChunk levelChunk) {
        Objects.requireNonNull(levelChunk, "chunk is null");
        return serverPlayerConsumer -> {
            Level patt0$temp = levelChunk.getLevel();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                PlayerSet.nearChunk(serverLevel, levelChunk.getPos()).apply(serverPlayerConsumer);
            }
        };
    }

    public static PlayerSet nearChunk(ServerLevel serverLevel, ChunkPos chunkPos) {
        Objects.requireNonNull(serverLevel, "server level is null");
        Objects.requireNonNull(chunkPos, "chunk pos is null");
        return serverPlayerConsumer -> serverLevel.getChunkSource().chunkMap.getPlayers(chunkPos, false).forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).apply(serverPlayerConsumer));
    }
}

