/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.resources.v1;

import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.flag.FeatureFlagSet;

public final class PackResourcesHelper {
    private PackResourcesHelper() {
    }

    public static Component getPackTitle(PackType packType) {
        return Component.literal((String)("Generated " + (packType == PackType.CLIENT_RESOURCES ? "Resource" : "Data") + " Pack"));
    }

    public static Component getPackDescription(String modId) {
        return (Component)ModLoaderEnvironment.INSTANCE.getModContainer(modId).map(ModContainer::getDisplayName).map(name -> Component.literal((String)("Resources for " + name))).orElseGet(() -> Component.literal((String)("Resources (" + modId + ")")));
    }

    public static Identifier getBuiltInPack(Identifier identifier, PackType packType) {
        return identifier.withPrefix(packType.getDirectory() + "/" + identifier.getNamespace() + "/" + (packType == PackType.CLIENT_RESOURCES ? "resourcepacks" : "datapacks") + "/");
    }

    public static RepositorySource buildClientPack(Identifier id, Supplier<AbstractModPackResources> factory, boolean hidden) {
        return PackResourcesHelper.buildClientPack(id, factory, true, Pack.Position.TOP, hidden, hidden);
    }

    public static RepositorySource buildClientPack(Identifier id, Supplier<AbstractModPackResources> factory, boolean required, Pack.Position position, boolean fixedPosition, boolean hidden) {
        return consumer -> consumer.accept(AbstractModPackResources.buildPack(PackType.CLIENT_RESOURCES, id, factory, PackResourcesHelper.getPackTitle(PackType.CLIENT_RESOURCES), PackResourcesHelper.getPackDescription(id.getNamespace()), required, position, fixedPosition, hidden, FeatureFlagSet.of()));
    }

    public static RepositorySource buildClientPack(Identifier id, Supplier<AbstractModPackResources> factory, Component title, Component description, boolean required, Pack.Position position, boolean fixedPosition, boolean hidden) {
        return consumer -> consumer.accept(AbstractModPackResources.buildPack(PackType.CLIENT_RESOURCES, id, factory, title, description, required, position, fixedPosition, hidden, FeatureFlagSet.of()));
    }

    public static RepositorySource buildServerPack(Identifier id, Supplier<AbstractModPackResources> factory, boolean hidden) {
        return PackResourcesHelper.buildServerPack(id, factory, true, Pack.Position.TOP, hidden, hidden);
    }

    public static RepositorySource buildServerPack(Identifier id, Supplier<AbstractModPackResources> factory, boolean required, Pack.Position position, boolean fixedPosition, boolean hidden) {
        return consumer -> consumer.accept(AbstractModPackResources.buildPack(PackType.SERVER_DATA, id, factory, PackResourcesHelper.getPackTitle(PackType.SERVER_DATA), PackResourcesHelper.getPackDescription(id.getNamespace()), required, position, fixedPosition, hidden, FeatureFlagSet.of()));
    }

    public static RepositorySource buildServerPack(Identifier id, Supplier<AbstractModPackResources> factory, Component title, Component description, boolean required, Pack.Position position, boolean fixedPosition, boolean hidden) {
        return consumer -> consumer.accept(AbstractModPackResources.buildPack(PackType.SERVER_DATA, id, factory, title, description, required, position, fixedPosition, hidden, FeatureFlagSet.of()));
    }

    public static Pack.Metadata createPackInfo(Identifier identifier, Component descriptionComponent, PackCompatibility packCompatibility, FeatureFlagSet featureFlagSet, boolean isHidden) {
        return ProxyImpl.get().createPackInfo(identifier, descriptionComponent, packCompatibility, featureFlagSet, isHidden);
    }

    public static boolean isPackHidden(Pack pack) {
        return ProxyImpl.get().isPackHidden(pack);
    }

    public static void setPackHidden(Pack pack) {
        ProxyImpl.get().setPackHidden(pack, true);
    }
}

