/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.attachment.builder;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.attachment.v4.DataAttachmentRegistry;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jspecify.annotations.Nullable;

public abstract class DataAttachmentBuilder<T, V, B extends DataAttachmentRegistry.Builder<T, V, B>>
implements DataAttachmentRegistry.Builder<T, V, B> {
    protected final Map<Predicate<T>, Function<RegistryAccess, V>> defaultValues = new LinkedHashMap<Predicate<T>, Function<RegistryAccess, V>>();
    protected @Nullable Codec<V> codec;
    protected @Nullable StreamCodec<? super RegistryFriendlyByteBuf, V> streamCodec;
    private @Nullable Function<T, PlayerSet> synchronizationTargets;

    @Override
    public B defaultValue(Function<RegistryAccess, V> defaultValueProvider) {
        Objects.requireNonNull(defaultValueProvider, "default value provider is null");
        this.defaultValues.put((Predicate<T>)Predicates.alwaysTrue(), (Function<RegistryAccess, Function<RegistryAccess, V>>)defaultValueProvider);
        return this.getThis();
    }

    @Override
    public B persistent(Codec<V> codec) {
        Objects.requireNonNull(codec, "codec is null");
        this.codec = codec;
        return this.getThis();
    }

    @Override
    public B networkSynchronized(StreamCodec<? super RegistryFriendlyByteBuf, V> streamCodec, Function<T, PlayerSet> synchronizationTargets) {
        Objects.requireNonNull(streamCodec, "stream codec is null");
        Objects.requireNonNull(synchronizationTargets, "synchronization targets is null");
        this.streamCodec = streamCodec;
        this.synchronizationTargets = synchronizationTargets;
        return this.getThis();
    }

    protected abstract RegistryAccess getRegistryAccess(T var1);

    protected boolean syncWith(T holder, ServerPlayer serverPlayer) {
        Objects.requireNonNull(this.synchronizationTargets, "synchronization targets is null");
        MutableBoolean mutableBoolean = new MutableBoolean();
        this.synchronizationTargets.apply(holder).apply(serverPlayerX -> {
            if (serverPlayer == serverPlayerX) {
                mutableBoolean.setTrue();
            }
        });
        return mutableBoolean.booleanValue();
    }
}

