/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.content;

import com.google.common.collect.Sets;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class ItemDataAccessor
implements DataAccessor {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(entity -> Component.translatableEscape((String)"commands.enchant.failed.entity", (Object[])new Object[]{entity}));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(entity -> Component.translatableEscape((String)"commands.enchant.failed.itemless", (Object[])new Object[]{entity}));
    public static final Function<String, DataCommands.DataProvider> PROVIDER = argumentName -> new DataCommands.DataProvider((String)argumentName){
        final /* synthetic */ String val$argumentName;
        {
            this.val$argumentName = string;
        }

        public DataAccessor access(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            Entity entity = EntityArgument.getEntity(context, (String)this.val$argumentName);
            if (!(entity instanceof LivingEntity)) {
                throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.getName().getString());
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack itemStack = livingEntity.getMainHandItem();
            if (itemStack.isEmpty()) {
                throw ERROR_NO_ITEM.create((Object)entity.getName().getString());
            }
            return new ItemDataAccessor(((CommandSourceStack)context.getSource()).registryAccess(), itemStack);
        }

        public ArgumentBuilder<CommandSourceStack, ?> wrap(ArgumentBuilder<CommandSourceStack, ?> builder, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> action) {
            return builder.then(Commands.literal((String)"item").then(action.apply((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument((String)this.val$argumentName, (ArgumentType)EntityArgument.entity()))));
        }
    };
    private final RegistryAccess registryAccess;
    private final ItemStack itemStack;

    public ItemDataAccessor(RegistryAccess registryAccess, ItemStack itemStack) {
        this.registryAccess = registryAccess;
        this.itemStack = itemStack;
    }

    public void setData(CompoundTag compoundTag) throws CommandSyntaxException {
        RegistryOps registryOps = this.registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        DataComponentMap.CODEC.parse((DynamicOps)registryOps, (Object)compoundTag).resultOrPartial().ifPresent(newComponents -> {
            DataComponentMap oldComponents = this.itemStack.getComponents();
            this.itemStack.applyComponents(this.constructDataComponentPatch(oldComponents, (DataComponentMap)newComponents));
        });
    }

    <T> DataComponentPatch constructDataComponentPatch(DataComponentMap oldComponents, DataComponentMap newComponents) {
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        for (DataComponentType dataComponentType : Sets.union((Set)oldComponents.keySet(), (Set)newComponents.keySet())) {
            Object t = newComponents.get(dataComponentType);
            if (!newComponents.has(dataComponentType)) {
                builder.remove(dataComponentType);
                continue;
            }
            if (Objects.equals(oldComponents.get(dataComponentType), t)) continue;
            builder.set(dataComponentType, t);
        }
        return builder.build();
    }

    public CompoundTag getData() {
        RegistryOps registryOps = this.registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return DataComponentMap.CODEC.encodeStart((DynamicOps)registryOps, (Object)this.itemStack.getComponents()).resultOrPartial(arg_0 -> ((Logger)PuzzlesLib.LOGGER).error(arg_0)).map(tag -> {
            CompoundTag compoundTag;
            return tag instanceof CompoundTag ? (compoundTag = (CompoundTag)tag) : null;
        }).orElseGet(CompoundTag::new);
    }

    public Component getModifiedSuccess() {
        return Component.translatable((String)"commands.data.entity.modified", (Object[])new Object[]{this.itemStack.getDisplayName()});
    }

    public Component getPrintSuccess(Tag tag) {
        return Component.translatable((String)"commands.data.entity.query", (Object[])new Object[]{this.itemStack.getDisplayName(), NbtUtils.toPrettyComponent((Tag)tag)});
    }

    public Component getPrintSuccess(NbtPathArgument.NbtPath path, double scale, int value) {
        return Component.translatable((String)"commands.data.entity.get", (Object[])new Object[]{path.asString(), this.itemStack.getDisplayName(), String.format(Locale.ROOT, "%.2f", scale), value});
    }
}

