/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.content;

import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.content.CommandOverrides;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.gamerules.GameRules;
import org.objectweb.asm.Type;

public class PuzzlesLibDevelopment
extends PuzzlesLib
implements ModConstructor {
    @Override
    public void onConstructMod() {
        CommandOverrides.registerEventHandlers();
    }

    @Override
    public void onCommonSetup() {
        PuzzlesLibDevelopment.initializeGameRules();
        PuzzlesLibDevelopment.initializeCommands();
    }

    private static void initializeCommands() {
        CommandOverrides.registerServerCommand("time set 4000", false);
        CommandOverrides.registerPlayerCommand("op @s", true);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.NIGHT_VISION);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.RESISTANCE);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.STRENGTH);
        CommandOverrides.registerEffectCommand((Holder<MobEffect>)MobEffects.WATER_BREATHING);
    }

    private static void initializeGameRules() {
        GameRules.ADVANCE_TIME.defaultValue = Boolean.FALSE;
        GameRules.ADVANCE_TIME.defaultValue = Boolean.FALSE;
        GameRules.ADVANCE_WEATHER.defaultValue = Boolean.FALSE;
        GameRules.KEEP_INVENTORY.defaultValue = true;
        GameRules.FIRE_SPREAD_RADIUS_AROUND_PLAYER.defaultValue = 0;
        GameRules.MOB_GRIEFING.defaultValue = Boolean.FALSE;
        GameRules.SPAWN_PHANTOMS.defaultValue = Boolean.FALSE;
        GameRules.SPAWN_PATROLS.defaultValue = Boolean.FALSE;
        GameRules.SPAWN_WANDERING_TRADERS.defaultValue = Boolean.FALSE;
        GameRules.SPREAD_VINES.defaultValue = Boolean.FALSE;
        GameRules.MAX_ENTITY_CRAMMING.defaultValue = 0;
        GameRules.PLAYERS_NETHER_PORTAL_DEFAULT_DELAY.defaultValue = 1;
        GameRules.COMMAND_BLOCK_OUTPUT.defaultValue = Boolean.FALSE;
    }

    public static void printClazzComponentsWithoutAccess(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isPublic(field.getModifiers()) || field.isSynthetic()) continue;
            LOGGER.info("transitive-accessible\tfield\t{}\t{}\t{}", new Object[]{Type.getInternalName(field.getDeclaringClass()), field.getName(), Type.getDescriptor(field.getType())});
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (Modifier.isPublic(((Method)accessibleObject).getModifiers()) || ((Method)accessibleObject).isSynthetic()) continue;
            LOGGER.info("transitive-accessible\tmethod\t{}\t{}\t{}", new Object[]{Type.getInternalName(((Method)accessibleObject).getDeclaringClass()), ((Method)accessibleObject).getName(), Type.getMethodDescriptor((Method)accessibleObject)});
        }
    }

    public static Identifier id(String path) {
        return Identifier.fromNamespaceAndPath((String)"puzzleslib", (String)path);
    }
}

