/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core.proxy;

import fuzs.puzzleslib.api.util.v1.CommonHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public interface SidedProxy {
    public void registerAllLoadingHandlers();

    public void registerAllEventHandlers();

    default public BlockableEventLoop<? super TickTask> getBlockableEventLoop(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getServer();
        }
        throw new RuntimeException("Blockable event loop accessed for the wrong physical side!");
    }

    default public RegistryAccess getRegistryAccess() {
        return CommonHelper.getMinecraftServer() != null ? CommonHelper.getMinecraftServer().registryAccess() : null;
    }

    default public Player getClientPlayer() {
        throw new RuntimeException("Client player accessed for the wrong physical side!");
    }

    default public Level getClientLevel() {
        throw new RuntimeException("Client level accessed for the wrong physical side!");
    }

    default public boolean hasControlDown() {
        return false;
    }

    default public boolean hasShiftDown() {
        return false;
    }

    default public boolean hasAltDown() {
        return false;
    }

    default public void registerConfigurationScreen(String modId, String ... otherModIds) {
    }

    @MustBeInvokedByOverriders
    default public void registerConfigurationScreenForHolder(String modId) {
        this.registerConfigurationScreen(modId, new String[0]);
    }
}

