/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.init;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import fuzs.puzzleslib.impl.core.Freezable;
import fuzs.puzzleslib.impl.item.CreativeModeTabHelper;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public abstract class RegistryManagerImpl
implements RegistryManager,
Freezable {
    protected final String modId;
    protected Set<ModLoader> allowedModLoaders = EnumSet.allOf(ModLoader.class);

    protected RegistryManagerImpl(String modId) {
        this.modId = modId;
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)modId), (Object)"mod id is invalid");
    }

    @Override
    public Identifier makeKey(String path) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)path), (Object)"path is invalid");
        return Identifier.fromNamespaceAndPath((String)this.modId, (String)path);
    }

    @Override
    public RegistryManager whenOn(ModLoader ... allowedModLoaders) {
        Preconditions.checkState((allowedModLoaders.length > 0 ? 1 : 0) != 0, (Object)"mod loaders is empty");
        this.allowedModLoaders = EnumSet.copyOf(Arrays.asList(allowedModLoaders));
        return this;
    }

    @Override
    public final <T> Holder.Reference<T> register(ResourceKey<? extends Registry<? super T>> registryKey, String path, Supplier<T> supplier) {
        this.isWritableOrThrow();
        return this.register(registryKey, path, supplier, false);
    }

    public final <T> Holder.Reference<T> register(ResourceKey<? extends Registry<? super T>> registryKey, String path, Supplier<T> supplier, boolean skipRegistration) {
        Objects.requireNonNull(registryKey, "registry key is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)path), (Object)"path is invalid");
        Objects.requireNonNull(supplier, "supplier is null");
        Holder.Reference holder = !this.allowedModLoaders.contains((Object)ModLoaderEnvironment.INSTANCE.getModLoader()) ? this.registerLazily(registryKey, path) : this.getHolderReference(registryKey, path, supplier, skipRegistration);
        this.allowedModLoaders = EnumSet.allOf(ModLoader.class);
        Objects.requireNonNull(holder, "holder is null");
        return holder;
    }

    protected abstract <T> Holder.Reference<T> getHolderReference(ResourceKey<? extends Registry<? super T>> var1, String var2, Supplier<T> var3, boolean var4);

    @Override
    public Holder.Reference<CreativeModeTab> registerCreativeModeTab(String path, Supplier<ItemStack> iconSupplier, CreativeModeTab.DisplayItemsGenerator displayItems, boolean withSearchBar) {
        return this.register(Registries.CREATIVE_MODE_TAB, path, () -> {
            CreativeModeTab.Builder builder = this.getCreativeModeTabBuilder(withSearchBar);
            Identifier identifier = this.makeKey(path);
            builder.title(CreativeModeTabHelper.getTitle(identifier));
            builder.icon(iconSupplier);
            builder.displayItems(displayItems);
            return builder.build();
        });
    }

    protected abstract CreativeModeTab.Builder getCreativeModeTabBuilder(boolean var1);
}

