/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.client.data.v2;

import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;

public abstract class AbstractSoundProvider
extends SoundDefinitionsProvider {
    public AbstractSoundProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractSoundProvider(String modId, PackOutput packOutput) {
        super(packOutput, modId);
    }

    protected static SoundDefinition.Sound sound(SoundEvent soundEvent) {
        return AbstractSoundProvider.sound((Identifier)soundEvent.location(), (SoundDefinition.SoundType)SoundDefinition.SoundType.EVENT);
    }

    public final void registerSounds() {
        this.addSounds();
    }

    public abstract void addSounds();

    protected void add(SoundEvent soundEvent, String ... sounds) {
        SoundDefinition definition = AbstractSoundProvider.definition();
        for (String sound : sounds) {
            definition.with(AbstractSoundProvider.sound((String)sound));
        }
        this.add(soundEvent, definition);
    }

    protected void add(SoundEvent soundEvent, Identifier ... sounds) {
        SoundDefinition definition = AbstractSoundProvider.definition();
        for (Identifier sound : sounds) {
            definition.with(AbstractSoundProvider.sound((Identifier)sound));
        }
        this.add(soundEvent, definition);
    }

    protected void add(SoundEvent soundEvent, SoundEvent ... soundEvents) {
        SoundDefinition definition = AbstractSoundProvider.definition();
        for (SoundEvent vanillaSoundEvent : soundEvents) {
            definition.with(AbstractSoundProvider.sound(vanillaSoundEvent));
        }
        this.add(soundEvent, definition);
    }

    protected void add(SoundEvent soundEvent, SoundDefinition.Sound ... sounds) {
        this.add(soundEvent.location(), AbstractSoundProvider.definition().with(sounds));
    }

    protected void addRecord(Holder<SoundEvent> soundEvent) {
        Identifier identifier = ((ResourceKey)soundEvent.unwrap().orThrow()).identifier().withPrefix("records/");
        SoundDefinition soundDefinition = AbstractSoundProvider.definition().with(AbstractSoundProvider.sound((Identifier)identifier).stream());
        this.add((SoundEvent)soundEvent.value(), soundDefinition);
        soundDefinition.subtitle(null);
    }

    protected void add(Identifier soundEvent, SoundDefinition definition) {
        super.add(soundEvent, definition.subtitle("subtitles." + soundEvent.getPath()));
    }

    public String getName() {
        return "Sounds";
    }
}

