/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.core.context;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.client.core.v1.context.GuiLayersContext;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;

public record GuiLayersContextNeoForgeImpl(RegisterGuiLayersEvent event) implements GuiLayersContext
{
    private static final Map<Identifier, Identifier> VANILLA_GUI_LAYERS = ImmutableMap.builder().put((Object)CAMERA_OVERLAYS, (Object)VanillaGuiLayers.CAMERA_OVERLAYS).put((Object)CROSSHAIR, (Object)VanillaGuiLayers.CROSSHAIR).put((Object)HOTBAR, (Object)VanillaGuiLayers.HOTBAR).put((Object)INFO_BAR, (Object)VanillaGuiLayers.CONTEXTUAL_INFO_BAR_BACKGROUND).put((Object)PLAYER_HEALTH, (Object)VanillaGuiLayers.PLAYER_HEALTH).put((Object)ARMOR_LEVEL, (Object)VanillaGuiLayers.ARMOR_LEVEL).put((Object)FOOD_LEVEL, (Object)VanillaGuiLayers.FOOD_LEVEL).put((Object)VEHICLE_HEALTH, (Object)VanillaGuiLayers.VEHICLE_HEALTH).put((Object)AIR_LEVEL, (Object)VanillaGuiLayers.AIR_LEVEL).put((Object)HELD_ITEM_TOOLTIP, (Object)VanillaGuiLayers.SELECTED_ITEM_NAME).put((Object)EXPERIENCE_LEVEL, (Object)VanillaGuiLayers.EXPERIENCE_LEVEL).put((Object)SPECTATOR_TOOLTIP, (Object)VanillaGuiLayers.SPECTATOR_TOOLTIP).put((Object)STATUS_EFFECTS, (Object)VanillaGuiLayers.EFFECTS).put((Object)BOSS_BAR, (Object)VanillaGuiLayers.BOSS_OVERLAY).put((Object)SLEEP_OVERLAY, (Object)VanillaGuiLayers.SLEEP_OVERLAY).put((Object)DEMO_TIMER, (Object)VanillaGuiLayers.DEMO_OVERLAY).put((Object)SCOREBOARD, (Object)VanillaGuiLayers.SCOREBOARD_SIDEBAR).put((Object)OVERLAY_MESSAGE, (Object)VanillaGuiLayers.OVERLAY_MESSAGE).put((Object)TITLE, (Object)VanillaGuiLayers.TITLE).put((Object)CHAT, (Object)VanillaGuiLayers.CHAT).put((Object)PLAYER_LIST, (Object)VanillaGuiLayers.TAB_LIST).put((Object)SUBTITLES, (Object)VanillaGuiLayers.SUBTITLE_OVERLAY).build();

    @Override
    public void registerGuiLayer(Identifier identifier, GuiLayersContext.Layer guiLayer) {
        Objects.requireNonNull(identifier, "identifier is null");
        Objects.requireNonNull(guiLayer, "gui layer is null");
        this.event.registerAboveAll(identifier, guiLayer::render);
    }

    @Override
    public void registerGuiLayer(Identifier identifier, Identifier otherResourceLocation, GuiLayersContext.Layer guiLayer) {
        Objects.requireNonNull(identifier, "identifier is null");
        Objects.requireNonNull(otherResourceLocation, "other identifier is null");
        Objects.requireNonNull(guiLayer, "gui layer is null");
        if (VANILLA_GUI_LAYERS.containsKey(identifier)) {
            this.event.registerAbove(VANILLA_GUI_LAYERS.get(identifier), otherResourceLocation, guiLayer::render);
        } else if (VANILLA_GUI_LAYERS.containsKey(otherResourceLocation)) {
            this.event.registerBelow(VANILLA_GUI_LAYERS.get(otherResourceLocation), identifier, guiLayer::render);
        } else {
            throw new RuntimeException("Unknown gui layers: " + String.valueOf(identifier) + ", " + String.valueOf(otherResourceLocation));
        }
    }

    @Override
    public void replaceGuiLayer(Identifier identifier, UnaryOperator<GuiLayersContext.Layer> guiLayerFactory) {
        Objects.requireNonNull(identifier, "identifier is null");
        Objects.requireNonNull(guiLayerFactory, "gui layer factory is null");
        if (!VANILLA_GUI_LAYERS.containsKey(identifier)) {
            throw new RuntimeException("Unknown gui layer: " + String.valueOf(identifier));
        }
        identifier = VANILLA_GUI_LAYERS.get(identifier);
        boolean isSleepOverlay = identifier.equals((Object)VanillaGuiLayers.SLEEP_OVERLAY);
        this.event.wrapLayer(identifier, guiLayer -> (guiGraphics, deltaTracker) -> {
            block3: {
                block2: {
                    if (isSleepOverlay) break block2;
                    if (Minecraft.getInstance().options.hideGui) break block3;
                }
                ((GuiLayersContext.Layer)guiLayerFactory.apply((arg_0, arg_1) -> ((GuiLayer)guiLayer).render(arg_0, arg_1))).render(guiGraphics, deltaTracker);
            }
        });
    }

    @Override
    public void addLeftStatusBarHeightProvider(Identifier identifier, ToIntFunction<Player> heightProvider) {
        this.addStatusBarHeight(identifier, heightProvider, (gui, height) -> gui.leftHeight += height.intValue());
    }

    @Override
    public void addRightStatusBarHeightProvider(Identifier identifier, ToIntFunction<Player> heightProvider) {
        this.addStatusBarHeight(identifier, heightProvider, (gui, height) -> gui.rightHeight += height.intValue());
    }

    private void addStatusBarHeight(Identifier identifier, ToIntFunction<Player> heightProvider, BiConsumer<Gui, Integer> heightConsumer) {
        Objects.requireNonNull(identifier, "identifier is null");
        Objects.requireNonNull(heightProvider, "height provider is null");
        NeoForge.EVENT_BUS.addListener(event -> {
            Gui gui;
            if (event.getName().equals((Object)identifier) && (gui = Minecraft.getInstance().gui).getCameraPlayer() != null) {
                heightConsumer.accept(gui, heightProvider.applyAsInt(gui.getCameraPlayer()));
            }
        });
    }
}

