/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.core.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.api.core.v1.context.VillagerTradesContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;

public final class VillagerTradesContextNeoForgeImpl
implements VillagerTradesContext {
    private final List<VillagerTrade> villagerTrades = new ArrayList<VillagerTrade>();
    private final List<WanderingTrade> wanderingTrades = new ArrayList<WanderingTrade>();

    @Override
    public void registerVillagerTrades(ResourceKey<VillagerProfession> profession, VillagerTradesContext.VillagerLevel level, Consumer<List<VillagerTrades.ItemListing>> factories) {
        Objects.requireNonNull(profession, "profession is null");
        Objects.requireNonNull(level, "level is null");
        Objects.requireNonNull(factories, "factories is null");
        if (this.villagerTrades.isEmpty()) {
            NeoForge.EVENT_BUS.addListener(event -> this.villagerTrades.forEach(villagerTrade -> villagerTrade.registerTrades((VillagerTradesEvent)event)));
        }
        this.villagerTrades.add(new VillagerTrade(profession, level, factories));
    }

    @Override
    public void registerWanderingTrades(VillagerTradesContext.WanderingTradesPool pool, VillagerTrades.ItemListing ... itemListings) {
        Objects.requireNonNull(pool, "pool is null");
        Objects.requireNonNull(itemListings, "item listings is null");
        Preconditions.checkArgument((itemListings.length > 0 ? 1 : 0) != 0, (Object)"item listings is empty");
        if (this.wanderingTrades.isEmpty()) {
            NeoForge.EVENT_BUS.addListener(event -> this.wanderingTrades.forEach(wanderingTrade -> wanderingTrade.registerTrades((WandererTradesEvent)event)));
        }
        this.wanderingTrades.add(new WanderingTrade(pool, (List<VillagerTrades.ItemListing>)ImmutableList.copyOf((Object[])itemListings)));
    }

    record VillagerTrade(ResourceKey<VillagerProfession> profession, VillagerTradesContext.VillagerLevel level, Consumer<List<VillagerTrades.ItemListing>> factories) {
        public void registerTrades(VillagerTradesEvent event) {
            List itemListings;
            if (event.getType().equals(this.profession) && (itemListings = (List)event.getTrades().get(this.level.getLevel())) != null) {
                this.factories.accept(itemListings);
            }
        }
    }

    record WanderingTrade(VillagerTradesContext.WanderingTradesPool pool, List<VillagerTrades.ItemListing> itemListings) {
        public void registerTrades(WandererTradesEvent event) {
            this.getTradesPool(event, this.pool).addAll(this.itemListings);
        }

        List<VillagerTrades.ItemListing> getTradesPool(WandererTradesEvent event, VillagerTradesContext.WanderingTradesPool pool) {
            return switch (pool) {
                default -> throw new MatchException(null, null);
                case VillagerTradesContext.WanderingTradesPool.PURCHASES -> event.getBuyingTrades();
                case VillagerTradesContext.WanderingTradesPool.COMMON_SALES -> event.getGenericTrades();
                case VillagerTradesContext.WanderingTradesPool.SPECIAL_SALES -> event.getRareTrades();
            };
        }
    }
}

