/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.text.multiline;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.text.multiline.MultilineStringView;
import com.teamresourceful.resourcefulconfig.client.components.options.text.multiline.MultilineTextInput;
import com.teamresourceful.resourcefulconfig.client.components.options.text.utils.TextBoxStringUtils;
import com.teamresourceful.resourcefulconfig.client.utils.ListenableState;
import com.teamresourceful.resourcefulconfig.client.utils.State;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class MultilineTextBox
extends BaseWidget {
    private final MultilineTextInput state;
    private static final int WIDTH = 80;
    private Font font;
    private double scroll;
    private int lastHeight;
    private boolean scrollbarHovered;

    public MultilineTextBox(State<String> state) {
        super(80, 16);
        ListenableState<String> listenableState;
        this.font = Minecraft.getInstance().font;
        this.scroll = -1.0;
        this.scrollbarHovered = false;
        if (state instanceof ListenableState) {
            ListenableState it = (ListenableState)state;
            listenableState = it;
        } else {
            listenableState = new ListenableState<String>(state);
        }
        this.state = new MultilineTextInput(listenableState);
    }

    public MultilineTextBox withFont(Font font) {
        this.font = font;
        return this;
    }

    protected void renderText(GuiGraphics graphics, int x, int y, int width) {
        int cursor = this.state.cursor();
        MultilineStringView selection = this.state.selection();
        List<MultilineStringView> lines = this.state.lines(this.width - 8);
        for (MultilineStringView line : lines) {
            String text = this.state.value().substring(line.start(), line.end());
            graphics.drawString(this.font, TextBoxStringUtils.format(text), x, y, -1);
            if (this.state.hasSelection()) {
                if (line.contains(selection.end()) || line.contains(selection.start())) {
                    int startIndex = Math.max(selection.start() - line.start(), 0);
                    int endIndex = selection.end() - line.start();
                    int startX = TextBoxStringUtils.width(this.font, text.substring(0, startIndex)) + x;
                    int endX = endIndex > text.length() ? x + width : startX + TextBoxStringUtils.width(this.font, text.substring(startIndex, endIndex));
                    Objects.requireNonNull(this.font);
                    graphics.fill(startX, y, endX, y + 9, -2136298838);
                } else if (selection.contains(line.start()) && selection.contains(line.end())) {
                    Objects.requireNonNull(this.font);
                    graphics.fill(x, y, x + width, y + 9, -2136298838);
                }
            }
            if (line.contains(cursor)) {
                String first = text.substring(0, cursor - line.start());
                int cursorX = TextBoxStringUtils.width(this.font, first) + x;
                Objects.requireNonNull(this.font);
                graphics.fill(cursorX, y, cursorX + 1, y + 9, System.currentTimeMillis() % 1000L < 500L ? -1 : 0);
            }
            Objects.requireNonNull(this.font);
            y += 9;
        }
        int n = lines.size();
        Objects.requireNonNull(this.font);
        this.lastHeight = n * 9;
        if (this.scroll == -1.0) {
            this.setScroll(this.lastHeight - (this.height - 8));
        }
    }

    protected void setScroll(double scroll) {
        this.scroll = Mth.clamp((double)scroll, (double)0.0, (double)Math.max(0, this.lastHeight - (this.height - 8)));
    }

    protected void changeScroll(double delta) {
        this.setScroll(this.scroll + delta);
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.isVisible()) {
            return;
        }
        Identifier texture = ModSprites.BUTTON;
        graphics.blitSprite(RenderPipelines.GUI_OPAQUE_TEXTURED_BACKGROUND, texture, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        boolean renderScrollbar = this.lastHeight > this.height - 8;
        graphics.enableScissor(this.getX() + 2, this.getY() + 3, this.getX() + this.getWidth() - 4, this.getY() + this.getHeight() - 2);
        this.renderText(graphics, this.getX() + 6 - (renderScrollbar ? 2 : 0), (int)((double)(this.getY() + 4) - this.scroll), this.getWidth() - 12);
        graphics.disableScissor();
        this.scrollbarHovered = false;
        if (renderScrollbar) {
            int minX = this.getX() + this.getWidth() - 5;
            int maxX = this.getX() + this.getWidth() - 3;
            graphics.fill(minX, this.getY() + 4, maxX, this.getY() + this.getHeight() - 4, -15592684);
            int scrollBarHeight = (int)((double)(this.height - 8) / (double)this.lastHeight * (double)(this.height - 8));
            int scrollBarY = (int)(this.scroll / (double)this.lastHeight * (double)(this.height - 8));
            this.scrollbarHovered = mouseX >= minX - 2 && mouseX < maxX + 2;
            graphics.fill(minX, this.getY() + 4 + scrollBarY, maxX, this.getY() + 4 + scrollBarY + scrollBarHeight, this.scrollbarHovered ? -12566464 : -13619152);
        }
        this.applyCursor(graphics);
    }

    @Override
    public void applyCursor(GuiGraphics graphics) {
        if (!this.isHovered()) {
            return;
        }
        if (!this.isActive()) {
            graphics.requestCursor(CursorTypes.NOT_ALLOWED);
        } else if (this.scrollbarHovered) {
            graphics.requestCursor(CursorTypes.POINTING_HAND);
        } else {
            graphics.requestCursor(CursorTypes.IBEAM);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.isVisible()) {
            return false;
        }
        this.changeScroll(scrollY * -10.0);
        return true;
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean doubleClicked) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.lastHeight > this.height - 8 && event.x() > (double)(this.getX() + this.getWidth() - 7)) {
            this.setScroll((event.y() - (double)this.getY() - 4.0) / (double)(this.height - 8) * (double)this.lastHeight);
            return true;
        }
        return this.state.onMouseClick(event.x() - (double)this.getX() - 4.0, event.y() - (double)this.getY() - 4.0 + this.scroll, event.input());
    }

    public boolean mouseDragged(@NotNull MouseButtonEvent event, double deltaX, double deltaY) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.lastHeight > this.height - 8 && event.x() > (double)(this.getX() + this.getWidth() - 7)) {
            return this.mouseClicked(event, false);
        }
        return this.state.onMouseDrag(event.x() - (double)this.getX() - 4.0, event.y() - (double)this.getY() - 4.0 + this.scroll, event.input());
    }

    public boolean keyPressed(@NotNull KeyEvent event) {
        if (!this.isVisible()) {
            return false;
        }
        boolean result = this.state.onKeyPress(event);
        int n = this.state.lines(this.width - 8).size();
        Objects.requireNonNull(this.font);
        this.lastHeight = n * 9;
        int n2 = this.state.getLineAtCursor();
        Objects.requireNonNull(this.font);
        this.setScroll(n2 * 9);
        return result;
    }

    public boolean charTyped(@NotNull CharacterEvent event) {
        if (!this.isVisible()) {
            return false;
        }
        int n = this.state.getLineAtCursor();
        Objects.requireNonNull(this.font);
        this.setScroll(n * 9);
        return this.state.onCharTyped(event);
    }

    public boolean isVisible() {
        return this.visible;
    }
}

