/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.utils.KeyCodeHelper;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class KeybindOptionWidget
extends BaseWidget {
    public static final int WIDTH = 80;
    public static final int HEIGHT = 16;
    private final Supplier<Integer> getter;
    private final Consumer<Integer> setter;
    private boolean isEditing = false;

    public KeybindOptionWidget(Supplier<Integer> getter, Consumer<Integer> setter) {
        super(80, 16);
        this.getter = getter;
        this.setter = setter;
    }

    private Component getDisplay() {
        MutableComponent display;
        int key = this.getter.get();
        MutableComponent mutableComponent = display = key == 0 ? Component.literal((String)"None") : KeyCodeHelper.getKeyName(key).copy();
        if (this.isEditing) {
            boolean strikethrough = System.currentTimeMillis() / 500L % 2L == 0L;
            return Component.literal((String)"> ").withColor(-9276296).append((Component)display.withStyle(style -> style.withUnderlined(Boolean.valueOf(strikethrough)).withColor(-329226))).append((Component)Component.literal((String)" <"));
        }
        return display;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.BUTTON, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int left = this.getX() + 4;
        int right = this.getX() + this.getWidth() - 4;
        graphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE).acceptScrolling((Component)this.getDisplay().copy().withColor(-9276296), (left + right) / 2, left, right, this.getY() + 2, this.getY() + this.getHeight() - 2);
        this.applyCursor(graphics);
    }

    public void onClick(@NotNull MouseButtonEvent event, boolean bl) {
        this.isEditing = true;
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean bl) {
        if (this.isEditing) {
            this.setter.accept(-100 - event.input());
            this.isEditing = false;
            return true;
        }
        return super.mouseClicked(event, bl);
    }

    public boolean keyPressed(@NotNull KeyEvent event) {
        if (this.isEditing) {
            this.setter.accept(event.input() == 256 ? 0 : event.input());
            this.isEditing = false;
            return true;
        }
        return super.keyPressed(event);
    }
}

