/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.range.OptionRange;
import java.util.List;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ActiveTextCollector;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RangeOptionWidget
extends BaseWidget {
    private static final int FOCUSED_EXTRA_WIDTH = 40;
    private static final int WIDTH = 80;
    private static final int FOCUSED_WIDTH = 120;
    private static final int PADDING = 20;
    private final Supplier<Component> display;
    private final Component minDisplay;
    private final Component maxDisplay;
    private final DoubleSupplier getter;
    private final DoubleConsumer setter;
    private final double step;
    private final boolean canBeFocused;
    private int padding = 5;
    private boolean canChangeValue;

    public RangeOptionWidget(OptionRange range) {
        this(range::toComponent, range.minComponent(), range.maxComponent(), range::getPercent, range::setPercent, range.getStepPercent());
    }

    public RangeOptionWidget(Supplier<Component> display, Component minDisplay, Component maxDisplay, DoubleSupplier getter, DoubleConsumer setter, Double step) {
        super(80, 16);
        this.display = display;
        this.minDisplay = minDisplay;
        this.maxDisplay = maxDisplay;
        this.getter = getter;
        this.setter = setter;
        this.step = step;
        this.canBeFocused = this.minDisplay != null && this.maxDisplay != null;
    }

    @Override
    public void applyCursor(GuiGraphics graphics) {
        if (!this.isHovered()) {
            return;
        }
        graphics.requestCursor(this.isActive() ? CursorTypes.RESIZE_EW : CursorTypes.NOT_ALLOWED);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.updateIfFocused();
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.BUTTON, this.getX(), this.getY(), this.width, this.height);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.BUTTON_HOVER, this.getX() + this.padding, this.getY() + 5, this.width - this.padding * 2, this.height - 10);
        int sliderX = this.getX() + this.padding + (int)((double)(this.width - this.padding * 2) * this.getter.getAsDouble()) - (this.height - 6) / 2;
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.CONTAINER, sliderX, this.getY() + 4, this.height - 8, this.height - 8);
        Component tooltip = null;
        if (mouseX >= this.getX() + this.padding && mouseX <= this.getX() + this.width - this.padding && mouseY >= this.getY() + 4 && mouseY <= this.getY() + this.height - 4) {
            tooltip = this.display.get();
            this.applyCursor(graphics);
        }
        if (this.isHoveredOrFocused() && this.canBeFocused) {
            ActiveTextCollector renderer = graphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE);
            renderer.acceptScrollingWithDefaultCenter(this.minDisplay, this.getX() + 2, this.getX() + this.padding - 2, this.getY() + 2, this.getY() + this.height - 2);
            renderer.acceptScrollingWithDefaultCenter(this.maxDisplay, this.getX() + this.width - this.padding + 2, this.getX() + this.width - 2, this.getY() + this.height - 2, this.getY() + 2);
            if (mouseX >= this.getX() + 2 && mouseX <= this.getX() + this.padding - 2) {
                tooltip = this.minDisplay;
            } else if (mouseX >= this.getX() + this.width - this.padding + 2 && mouseX <= this.getX() + this.width - 2) {
                tooltip = this.maxDisplay;
            }
        }
        if (tooltip != null && Minecraft.getInstance().screen != null && this.isHovered()) {
            graphics.setTooltipForNextFrame(List.of(tooltip.getVisualOrderText()), mouseX, mouseY);
        }
    }

    public void updateIfFocused() {
        if (!this.canBeFocused) {
            return;
        }
        if (this.width != 120 && this.isHoveredOrFocused()) {
            this.setWidth(120);
            this.setX(this.getX() - 40);
            this.padding = 20;
        } else if (this.width != 80 && !this.isHoveredOrFocused()) {
            this.setWidth(80);
            this.setX(this.getX() + 40);
            this.padding = 5;
        }
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused) {
            this.canChangeValue = false;
        } else {
            InputType type = Minecraft.getInstance().getLastInputType();
            if (type.isMouse() || type == InputType.KEYBOARD_TAB) {
                this.canChangeValue = true;
            }
        }
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean bl) {
        if (this.isHovered()) {
            this.setValueFromMouse(event.x());
            return true;
        }
        return false;
    }

    public boolean mouseDragged(@NotNull MouseButtonEvent event, double dragX, double dragY) {
        if (this.isHovered() && event.button() == 0) {
            this.setValueFromMouse(event.x());
            return true;
        }
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.isSelection()) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean leftArrow;
            boolean bl = leftArrow = event.input() == 263;
            if (leftArrow || event.input() == 262) {
                double step = leftArrow ? -this.step : this.step;
                double value = (this.getter.getAsDouble() + (step *= event.hasShiftDown() ? 10.0 : 1.0)) / (double)(this.width - 8);
                this.setter.accept(Mth.clamp((double)value, (double)0.0, (double)1.0));
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        if (!this.isFocused()) {
            return;
        }
        double correctX = mouseX - (double)(this.getX() + this.padding);
        double value = correctX / (double)(this.getWidth() - this.padding * 2);
        this.setter.accept(Mth.clamp((double)value, (double)0.0, (double)1.0));
    }
}

