/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.options.text.TextBox;
import com.teamresourceful.resourcefulconfig.client.utils.ListenableState;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;

public class StringOptionWidget
extends TextBox {
    private static final int FOCUSED_EXTRA_WIDTH = 40;
    private static final int WIDTH = 80;
    private static final int FOCUSED_WIDTH = 120;
    private final Supplier<String> getter;
    private final Function<String, Boolean> setter;
    private final boolean canExpand;

    public StringOptionWidget(Supplier<String> getter, Function<String, Boolean> setter) {
        this(getter, setter, true);
    }

    public StringOptionWidget(Supplier<String> getter, Function<String, Boolean> setter, boolean canExpand) {
        super(80, 16, ListenableState.of(getter.get()));
        this.setMaxLength(Short.MAX_VALUE);
        this.getter = getter;
        this.setter = setter;
        this.canExpand = canExpand;
        this.state.registerListener(it -> {
            if (this.setter.apply((String)it).booleanValue()) {
                this.setTextColor(-2039584);
            } else {
                this.setTextColor(-65536);
            }
        });
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.updateIfFocused();
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.BUTTON, this.getX(), this.getY(), this.width, this.height);
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }

    public void updateIfFocused() {
        if (!this.isFocused()) {
            this.setValue(this.getter.get());
        }
        if (!this.canExpand) {
            return;
        }
        if (this.width != 120 && this.isFocused()) {
            this.setWidth(120);
            this.setX(this.getX() - 40);
        } else if (this.width != 80 && !this.isFocused()) {
            this.setWidth(80);
            this.setX(this.getX() + 40);
        }
    }
}

