/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types.color;

import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.ColorOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbColor;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbState;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.RecentColorStorage;
import com.teamresourceful.resourcefulconfig.client.utils.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class PresetsSelector
extends BaseWidget {
    private static final List<HsbColor> MINECRAFT_COLORS = List.of(HsbColor.fromRgb(-43691), HsbColor.fromRgb(-22016), HsbColor.fromRgb(-171), HsbColor.fromRgb(-11141291), HsbColor.fromRgb(0x55FFFF), HsbColor.fromRgb(-11184641), HsbColor.fromRgb(-43521), HsbColor.fromRgb(-1), HsbColor.fromRgb(-5592406), HsbColor.fromRgb(-5636096), HsbColor.fromRgb(-16733696), HsbColor.fromRgb(-16733526), HsbColor.fromRgb(-16777046), HsbColor.fromRgb(-5635926), HsbColor.fromRgb(-11184811), HsbColor.fromRgb(-16777216));
    private final int[] presets;
    private final State<ColorOptionWidget.PresetType> type;
    private final HsbState state;
    private final boolean withAlpha;
    private Collection<HsbColor> colors = new ArrayList<HsbColor>();
    private ColorOptionWidget.PresetType lastType;

    public PresetsSelector(int width, int[] presets, State<ColorOptionWidget.PresetType> type, HsbState state, boolean withAlpha) {
        super(width, width / 8 * 2 + 4);
        this.presets = presets;
        this.type = type;
        this.state = state;
        this.getColors();
        this.withAlpha = withAlpha;
    }

    private Collection<HsbColor> getColors() {
        if (this.lastType != this.type.get()) {
            this.colors = switch ((ColorOptionWidget.PresetType)this.type.get()) {
                default -> throw new MatchException(null, null);
                case ColorOptionWidget.PresetType.DEFAULTS -> {
                    ArrayList<HsbColor> colors = new ArrayList<HsbColor>();
                    for (int preset : this.presets) {
                        int color = this.withAlpha ? preset : preset | 0xFF000000;
                        colors.add(HsbColor.fromRgb(color));
                    }
                    yield colors;
                }
                case ColorOptionWidget.PresetType.RECENTS -> RecentColorStorage.getRecentColors(this.withAlpha);
                case ColorOptionWidget.PresetType.MC_COLORS -> MINECRAFT_COLORS;
            };
            this.lastType = (ColorOptionWidget.PresetType)this.type.get();
        }
        return this.colors;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.ACCENT, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.BUTTON, this.getX() + 1, this.getX() + 1, this.getWidth() - 2, this.getHeight() - 2);
        int size = (this.getWidth() - 18) / 8;
        int i = 0;
        for (HsbColor color : this.getColors()) {
            if (i >= 16) break;
            int j = i % 8;
            int k = i / 8;
            int x = this.getX() + 3 + j * size + 2 * j;
            int y = this.getY() + 3 + k * size + 2 * k;
            int rgba = color.toRgba();
            graphics.fill(x, y, x + size, y + size, rgba);
            graphics.renderOutline(x, y, size, size, -2236963);
            if (mouseX >= x && mouseX <= x + size && mouseY >= y && mouseY <= y + size) {
                graphics.renderOutline(x, y, size, size, -16777216);
                Screen screen = Minecraft.getInstance().screen;
                if (screen != null) {
                    if (!this.withAlpha) {
                        rgba &= 0xFFFFFF;
                    }
                    MutableComponent text = Component.literal((String)"[").withColor(rgba | 0xFF000000).append((Component)Component.literal((String)String.format(Locale.ROOT, "#%06X", rgba)).withColor(-1)).append((Component)Component.literal((String)"]")).withColor(rgba | 0xFF000000);
                    graphics.setTooltipForNextFrame((Component)text, mouseX, mouseY);
                }
                this.applyCursor(graphics);
            }
            ++i;
        }
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean bl) {
        if (event.input() != 0) {
            return false;
        }
        int size = (this.getWidth() - 18) / 8;
        int i = 0;
        for (HsbColor color : this.getColors()) {
            if (i >= 16) break;
            int j = i % 8;
            int k = i / 8;
            int x = this.getX() + 3 + j * size + 2 * j;
            int y = this.getY() + 3 + k * size + 2 * k;
            if (event.x() >= (double)x && event.x() <= (double)(x + size) && event.y() >= (double)y && event.y() <= (double)(y + size)) {
                RecentColorStorage.add(this.state.get());
                this.lastType = null;
                this.state.set(color);
                return true;
            }
            ++i;
        }
        return false;
    }
}

