/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types.color;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbColor;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbState;
import com.teamresourceful.resourcefulconfig.mixins.client.GuiGraphicsAccessor;
import net.minecraft.Optionull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class SaturationBrightnessSelector
extends BaseWidget {
    private final HsbState state;

    public SaturationBrightnessSelector(int width, int height, HsbState state) {
        super(width, height);
        this.state = state;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        HsbColor color = this.state.get();
        int posX = Math.round(color.saturation() * (float)this.getWidth());
        int posY = this.getHeight() - Math.round(color.brightness() * (float)this.getHeight());
        int tileWidth = Math.round((float)this.getWidth() / 10.0f);
        int tileHeight = Math.round((float)this.getHeight() / 10.0f);
        for (int dy = 0; dy < 10; ++dy) {
            float minB = (float)dy / 10.0f;
            float maxB = (float)(dy + 1) / 10.0f;
            for (int dx = 0; dx < 10; ++dx) {
                float minS = (float)dx / 10.0f;
                float maxS = (float)(dx + 1) / 10.0f;
                this.drawGradient(graphics, this.getX() + dx * tileWidth, this.getY() + (10 - dy - 1) * tileHeight, tileWidth, tileHeight, HsbColor.of(color.hue(), minS, maxB, 255).toRgba(), HsbColor.of(color.hue(), maxS, maxB, 255).toRgba(), HsbColor.of(color.hue(), minS, minB, 255).toRgba(), HsbColor.of(color.hue(), maxS, minB, 255).toRgba());
            }
        }
        graphics.renderOutline(this.getX() + posX - 1, this.getY() + posY - 1, 3, 3, -16777216);
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean bl) {
        if (event.input() != 0) {
            return false;
        }
        if (!this.isMouseOver(event.x(), event.y())) {
            return false;
        }
        int x = (int)event.x() - this.getX();
        int y = (int)event.y() - this.getY();
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return false;
        }
        this.state.set(HsbColor.of(this.state.get().hue(), Mth.clamp((float)((float)x / (float)this.getWidth()), (float)0.0f, (float)1.0f), 1.0f - Mth.clamp((float)((float)y / (float)this.getHeight()), (float)0.0f, (float)1.0f), 255));
        return true;
    }

    public boolean mouseDragged(@NotNull MouseButtonEvent event, double d, double e) {
        return this.mouseClicked(event, false);
    }

    private void drawGradient(GuiGraphics graphics, int x, int y, int width, int height, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        GuiGraphicsAccessor access = (GuiGraphicsAccessor)graphics;
        access.getGuiRenderState().submitGuiElement((GuiElementRenderState)new GradientRenderState(new Matrix3x2f((Matrix3x2fc)graphics.pose()), x, y, x + width, y + height, topLeft, topRight, bottomLeft, bottomRight));
    }

    private record GradientRenderState(Matrix3x2f pose, int x0, int y0, int x1, int y1, int col1, int col2, int col3, int col4) implements GuiElementRenderState
    {
        public void buildVertices(@NotNull VertexConsumer consumer) {
            consumer.addVertexWith2DPose((Matrix3x2fc)this.pose(), (float)this.x0(), (float)this.y0()).setColor(this.col1());
            consumer.addVertexWith2DPose((Matrix3x2fc)this.pose(), (float)this.x0(), (float)this.y1()).setColor(this.col3());
            consumer.addVertexWith2DPose((Matrix3x2fc)this.pose(), (float)this.x1(), (float)this.y1()).setColor(this.col4());
            consumer.addVertexWith2DPose((Matrix3x2fc)this.pose(), (float)this.x1(), (float)this.y0()).setColor(this.col2());
        }

        @NotNull
        public RenderPipeline pipeline() {
            return RenderPipelines.GUI;
        }

        @NotNull
        public TextureSetup textureSetup() {
            return TextureSetup.noTexture();
        }

        @Nullable
        public ScreenRectangle bounds() {
            return (ScreenRectangle)Optionull.map((Object)Minecraft.getInstance().screen, Screen::getRectangle);
        }

        @Nullable
        public ScreenRectangle scissorArea() {
            return (ScreenRectangle)Optionull.map((Object)Minecraft.getInstance().screen, Screen::getRectangle);
        }
    }
}

