/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ConfigSearching {
    private static final BiMap<String, String> ALIASES = HashBiMap.create();
    private static final Cache<String, List<String>> CACHE = CacheBuilder.newBuilder().maximumSize(300L).build();

    public static List<String> getAdditionalTerms(String text) {
        List cached = (List)CACHE.getIfPresent((Object)text);
        if (cached != null) {
            return cached;
        }
        ArrayList<String> terms = new ArrayList<String>();
        for (String s : text.split(" ")) {
            if (ALIASES.containsKey((Object)s)) {
                terms.add((String)ALIASES.get((Object)s));
            }
            if (!ALIASES.containsValue((Object)s)) continue;
            terms.add((String)ALIASES.inverse().get((Object)s));
        }
        CACHE.put((Object)text, terms);
        return terms;
    }

    static {
        ALIASES.put((Object)"color", (Object)"colour");
        ALIASES.put((Object)"gray", (Object)"grey");
        ALIASES.put((Object)"center", (Object)"centre");
        ALIASES.put((Object)"favorite", (Object)"favourite");
        ALIASES.put((Object)"armor", (Object)"armour");
    }
}

