/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import me.wesley1808.servercore.common.ServerCore;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.Copyable;
import me.wesley1808.servercore.common.services.platform.PlatformHelper;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import space.arim.dazzleconf.AuxiliaryKeys;
import space.arim.dazzleconf.ConfigurationFactory;
import space.arim.dazzleconf.ConfigurationOptions;
import space.arim.dazzleconf.error.ConfigFormatSyntaxException;
import space.arim.dazzleconf.error.InvalidConfigException;
import space.arim.dazzleconf.ext.snakeyaml.CommentMode;
import space.arim.dazzleconf.ext.snakeyaml.SnakeYamlConfigurationFactory;
import space.arim.dazzleconf.ext.snakeyaml.SnakeYamlOptions;
import space.arim.dazzleconf.sorter.AnnotationBasedSorter;
import space.arim.dazzleconf.sorter.ConfigurationSorter;

public class ConfigManager<C extends Copyable> {
    private static final Path CONFIG_DIR = PlatformHelper.getConfigDir().resolve("servercore");
    private final ConfigurationFactory<C> factory;
    private final String fileName;
    private C data;

    private ConfigManager(ConfigurationFactory<C> factory, String fileName) {
        this.factory = factory;
        this.fileName = fileName;
    }

    public static <C extends Copyable> ConfigManager<C> create(String fileName, Class<C> configClass) {
        SnakeYamlOptions yamlOptions = new SnakeYamlOptions.Builder().commentMode(CommentMode.alternativeWriter((String)"# %s")).charset(StandardCharsets.UTF_8).yamlSupplier(() -> {
            DumperOptions opts = new DumperOptions();
            opts.setProcessComments(true);
            opts.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            opts.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
            opts.setPrettyFlow(true);
            opts.setSplitLines(false);
            return new Yaml(opts);
        }).build();
        ConfigurationOptions options = new ConfigurationOptions.Builder().sorter((ConfigurationSorter)new AnnotationBasedSorter()).build();
        ConfigurationFactory configFactory = SnakeYamlConfigurationFactory.create(configClass, (ConfigurationOptions)options, (SnakeYamlOptions)yamlOptions);
        return new ConfigManager<C>(configFactory, fileName);
    }

    public boolean reload() {
        try {
            C loadedData = this.reloadConfigData();
            this.copyAndSetData(loadedData);
            return true;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (ConfigFormatSyntaxException ex) {
            ServerCore.LOGGER.error("[ServerCore] The yaml syntax in {} is invalid. Check your YAML syntax with a tool such as https://yaml-online-parser.appspot.com/", (Object)this.fileName);
            this.printError(ex.getMessage());
        }
        catch (InvalidConfigException ex) {
            ServerCore.LOGGER.error("[ServerCore] One of the values in {} is not valid.", (Object)this.fileName);
            this.printError(ex.getMessage());
        }
        if (this.data == null) {
            Copyable defaultData = (Copyable)this.factory.loadDefaults();
            this.copyAndSetData(defaultData);
        }
        return false;
    }

    private C reloadConfigData() throws IOException, InvalidConfigException {
        Copyable loadedData;
        Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
        Copyable defaults = (Copyable)this.factory.loadDefaults();
        Path configPath = CONFIG_DIR.resolve(this.fileName);
        if (!Files.exists(configPath, new LinkOption[0])) {
            try (FileChannel fileChannel = FileChannel.open(configPath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                this.factory.write((Object)defaults, (WritableByteChannel)fileChannel);
            }
            return (C)defaults;
        }
        try (FileChannel fileChannel = FileChannel.open(configPath, StandardOpenOption.READ);){
            loadedData = (Copyable)this.factory.load((ReadableByteChannel)fileChannel, (Object)defaults);
        }
        if (Config.shouldValidate() && loadedData instanceof AuxiliaryKeys) {
            fileChannel = FileChannel.open(configPath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            try {
                this.factory.write((Object)loadedData, (WritableByteChannel)fileChannel);
            }
            finally {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
        }
        return (C)loadedData;
    }

    private void printError(String message) {
        String[] errors = StringUtils.split((String)message, (String)System.lineSeparator());
        String separator = "-".repeat(100);
        ServerCore.LOGGER.error(separator);
        for (String error : errors) {
            ServerCore.LOGGER.error(error);
        }
        ServerCore.LOGGER.error(separator);
    }

    public C get() {
        return this.data;
    }

    public boolean isLoaded() {
        return this.data != null;
    }

    private void copyAndSetData(C source) {
        this.data = source.optimizedCopy();
    }
}

