/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config.serialization;

import java.util.Optional;
import me.wesley1808.servercore.common.config.Config;
import net.minecraft.world.entity.EntityType;
import space.arim.dazzleconf.error.BadValueException;
import space.arim.dazzleconf.serialiser.Decomposer;
import space.arim.dazzleconf.serialiser.FlexibleType;
import space.arim.dazzleconf.serialiser.ValueSerialiser;

public class EntityTypeSerializer
implements ValueSerialiser<EntityType> {
    public Class<EntityType> getTargetClass() {
        return EntityType.class;
    }

    public EntityType<?> deserialise(FlexibleType flexibleType) throws BadValueException {
        String key = flexibleType.getString();
        Optional type = EntityType.byString((String)key);
        if (type.isEmpty()) {
            if (Config.shouldValidate()) {
                throw flexibleType.badValueExceptionBuilder().message("Unknown entity type: " + key).build();
            }
            return EntityType.MARKER;
        }
        return (EntityType)type.get();
    }

    public Object serialise(EntityType value, Decomposer decomposer) {
        return EntityType.getKey((EntityType)value).toString();
    }
}

