/*
 * Decompiled with CFR 0.152.
 */
package com.simpleluckyblock;

import com.simpleluckyblock.SimpleLuckyBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class LuckyBlock
extends Block {
    public LuckyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.generateDrops(serverLevel, pos, player);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    private void generateDrops(ServerLevel level, BlockPos pos, Player player) {
        RandomSource random = level.random;
        float chance = random.nextFloat();
        if (chance < 0.2f) {
            this.generateUnluckyDrops(level, pos, player, random);
            level.playSound(null, pos, SoundEvents.VILLAGER_NO, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (chance < 0.85f) {
            this.generateNormalDrops(level, pos, player, random);
            level.playSound(null, pos, SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            this.generateVeryLuckyDrops(level, pos, player, random);
            level.playSound(null, pos, SoundEvents.TOTEM_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.spawnTotemParticles(level, pos);
        }
    }

    private void generateUnluckyDrops(ServerLevel level, BlockPos pos, Player player, RandomSource random) {
        int category = random.nextInt(5);
        switch (category) {
            case 0: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIRT, 1 + random.nextInt(5)));
                break;
            }
            case 1: {
                level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 2.5f, Level.ExplosionInteraction.BLOCK);
                break;
            }
            case 2: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.ROTTEN_FLESH, 3 + random.nextInt(8)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.SPIDER_EYE, 1 + random.nextInt(3)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.POISONOUS_POTATO, 2 + random.nextInt(4)));
                break;
            }
            case 3: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GRAVEL, 5 + random.nextInt(10)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.COBBLESTONE, 4 + random.nextInt(8)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.SAND, 3 + random.nextInt(6)));
                break;
            }
            case 4: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.STICK, 10 + random.nextInt(15)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DEAD_BUSH, 2 + random.nextInt(5)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.FLINT, 4 + random.nextInt(8)));
            }
        }
    }

    private void generateNormalDrops(ServerLevel level, BlockPos pos, Player player, RandomSource random) {
        int category = random.nextInt(25);
        switch (category) {
            case 0: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.WOODEN_SWORD));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.WOODEN_PICKAXE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.WOODEN_AXE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.WOODEN_SHOVEL));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.WOODEN_HOE));
                break;
            }
            case 1: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.STONE_SWORD));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.STONE_PICKAXE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.STONE_AXE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.STONE_SHOVEL));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.STONE_HOE));
                break;
            }
            case 2: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_SWORD));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_PICKAXE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_AXE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_SHOVEL));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_HOE));
                break;
            }
            case 3: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.LEATHER_HELMET));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.LEATHER_LEGGINGS));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.LEATHER_BOOTS));
                break;
            }
            case 4: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_HELMET));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_LEGGINGS));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_BOOTS));
                break;
            }
            case 5: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.IRON_HELMET));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.IRON_CHESTPLATE));
                break;
            }
            case 6: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.SPONGE, 1 + random.nextInt(3)));
                break;
            }
            case 7: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.ENDER_CHEST, 2));
                break;
            }
            case 8: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.ENDER_PEARL, 2 + random.nextInt(3)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.ENDER_EYE, 1 + random.nextInt(2)));
                break;
            }
            case 9: {
                ItemStack clock = new ItemStack((ItemLike)Items.CLOCK);
                clock.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Lucky Clock"));
                this.dropItems(level, pos, clock);
                break;
            }
            case 10: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.LAVA_BUCKET));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.WATER_BUCKET));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.MILK_BUCKET));
                break;
            }
            case 11: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.WHITE_DYE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.RED_DYE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.BLUE_DYE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GREEN_DYE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.YELLOW_DYE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.BLACK_DYE));
                break;
            }
            case 12: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.PUMPKIN, 2 + random.nextInt(4)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.JACK_O_LANTERN, 1 + random.nextInt(3)));
                break;
            }
            case 13: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.TNT, 1 + random.nextInt(3)));
                break;
            }
            case 14: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.SADDLE, 1 + random.nextInt(2)));
                break;
            }
            case 15: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.BREAD, 3 + random.nextInt(5)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.APPLE, 2 + random.nextInt(4)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_APPLE));
                break;
            }
            case 16: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.REDSTONE, 5 + random.nextInt(10)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.REPEATER, 2 + random.nextInt(3)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.COMPARATOR));
                break;
            }
            case 17: {
                this.spawnFallingBlock(level, pos, Blocks.DIAMOND_BLOCK, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                break;
            }
            case 18: {
                this.spawnFallingBlock(level, pos, Blocks.GOLD_BLOCK, (ParticleOptions)ParticleTypes.CRIT);
                break;
            }
            case 19: {
                this.spawnFallingBlock(level, pos, Blocks.EMERALD_BLOCK, (ParticleOptions)ParticleTypes.ENCHANT);
                break;
            }
            case 20: {
                this.spawnFallingBlock(level, pos, Blocks.IRON_BLOCK, (ParticleOptions)ParticleTypes.SMOKE);
                break;
            }
            case 21: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.COD, 2 + random.nextInt(4)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.SALMON, 1 + random.nextInt(3)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.FISHING_ROD));
                break;
            }
            case 22: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.BEEF, 2 + random.nextInt(4)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.PORKCHOP, 2 + random.nextInt(4)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.CHICKEN, 2 + random.nextInt(4)));
                break;
            }
            case 23: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.BOOK, 3 + random.nextInt(5)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.BOOKSHELF, 1 + random.nextInt(3)));
                break;
            }
            case 24: {
                List<ItemStack> spawnEggs = List.of(new ItemStack((ItemLike)Items.SHEEP_SPAWN_EGG), new ItemStack((ItemLike)Items.HORSE_SPAWN_EGG), new ItemStack((ItemLike)Items.LLAMA_SPAWN_EGG), new ItemStack((ItemLike)Items.WOLF_SPAWN_EGG), new ItemStack((ItemLike)Items.RABBIT_SPAWN_EGG), new ItemStack((ItemLike)Items.CAT_SPAWN_EGG));
                this.dropItems(level, pos, spawnEggs.get(random.nextInt(spawnEggs.size())));
            }
        }
    }

    private void generateVeryLuckyDrops(ServerLevel level, BlockPos pos, Player player, RandomSource random) {
        int category = random.nextInt(13);
        switch (category) {
            case 0: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND_HELMET));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND_BOOTS));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.ENCHANTED_BOOK, 2 + random.nextInt(3)));
                break;
            }
            case 1: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.LEATHER_HORSE_ARMOR));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.IRON_HORSE_ARMOR));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_HORSE_ARMOR));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND_HORSE_ARMOR));
                break;
            }
            case 2: {
                List<ItemStack> diamondTools = List.of(new ItemStack((ItemLike)Items.DIAMOND_SWORD), new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), new ItemStack((ItemLike)Items.DIAMOND_AXE), new ItemStack((ItemLike)Items.DIAMOND_SHOVEL), new ItemStack((ItemLike)Items.DIAMOND_HOE));
                for (int i = 0; i < 1 + random.nextInt(2); ++i) {
                    this.dropItems(level, pos, diamondTools.get(random.nextInt(diamondTools.size())));
                }
                break;
            }
            case 3: {
                List<ItemStack> chainmailPieces = List.of(new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS));
                for (int i = 0; i < 2 + random.nextInt(2); ++i) {
                    this.dropItems(level, pos, chainmailPieces.get(random.nextInt(chainmailPieces.size())));
                }
                break;
            }
            case 4: {
                List<ItemStack> diamondArmor = List.of(new ItemStack((ItemLike)Items.DIAMOND_HELMET), new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), new ItemStack((ItemLike)Items.DIAMOND_BOOTS));
                for (int i = 0; i < 1 + random.nextInt(2); ++i) {
                    this.dropItems(level, pos, diamondArmor.get(random.nextInt(diamondArmor.size())));
                }
                break;
            }
            case 5: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.END_PORTAL_FRAME, 2 + random.nextInt(5)));
                break;
            }
            case 6: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND_SWORD));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.ENCHANTED_BOOK, 1 + random.nextInt(2)));
                break;
            }
            case 7: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.CHICKEN_SPAWN_EGG, 3 + random.nextInt(5)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND, 2 + random.nextInt(4)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.EGG, 5 + random.nextInt(8)));
                break;
            }
            case 8: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.CHEST));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.IRON_NUGGET, 8 + random.nextInt(16)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLD_INGOT, 3 + random.nextInt(6)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND, 2 + random.nextInt(4)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.EMERALD, 1 + random.nextInt(3)));
                this.dropItems(level, pos, new ItemStack((ItemLike)SimpleLuckyBlock.LUCKY_BLOCK_ITEM.get(), 1 + random.nextInt(3)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_APPLE, 1 + random.nextInt(3)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.ENCHANTED_GOLDEN_APPLE));
                break;
            }
            case 9: {
                this.dropItems(level, pos, new ItemStack((ItemLike)SimpleLuckyBlock.LUCKY_BLOCK_ITEM.get(), 3 + random.nextInt(5)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND, 4 + random.nextInt(6)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.EMERALD, 2 + random.nextInt(4)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLD_BLOCK, 1 + random.nextInt(3)));
                break;
            }
            case 10: {
                List<ItemStack> rareItems = List.of(new ItemStack((ItemLike)Items.NETHER_STAR), new ItemStack((ItemLike)Items.BEACON), new ItemStack((ItemLike)Items.DRAGON_EGG));
                this.dropItems(level, pos, rareItems.get(random.nextInt(rareItems.size())));
                break;
            }
            case 11: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.ENCHANTING_TABLE));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.BOOKSHELF, 4 + random.nextInt(8)));
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.LAPIS_LAZULI, 8 + random.nextInt(16)));
                break;
            }
            case 12: {
                this.dropItems(level, pos, new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE, 10 + random.nextInt(15)));
                this.spawnExperienceShower(level, pos);
            }
        }
    }

    private void dropItems(ServerLevel level, BlockPos pos, ItemStack stack) {
        if (!stack.isEmpty()) {
            double x = (double)pos.getX() + 0.5 + (level.random.nextDouble() - 0.5) * 0.8;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5 + (level.random.nextDouble() - 0.5) * 0.8;
            ItemEntity itemEntity = new ItemEntity((Level)level, x, y, z, stack);
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    private void spawnFallingBlock(ServerLevel level, BlockPos pos, Block block, ParticleOptions particle) {
        FallingBlockEntity fallingBlock = FallingBlockEntity.fall((Level)level, (BlockPos)pos.above(3), (BlockState)block.defaultBlockState());
        level.addFreshEntity((Entity)fallingBlock);
        for (int i = 0; i < 10; ++i) {
            double x = (double)pos.getX() + 0.5 + (level.random.nextDouble() - 0.5) * 2.0;
            double y = (double)pos.getY() + 3.5 + level.random.nextDouble() * 2.0;
            double z = (double)pos.getZ() + 0.5 + (level.random.nextDouble() - 0.5) * 2.0;
            level.sendParticles(particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private void spawnTotemParticles(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            double x = (double)pos.getX() + 0.5 + (level.random.nextDouble() - 0.5) * 2.0;
            double y = (double)pos.getY() + 0.5 + level.random.nextDouble() * 2.0;
            double z = (double)pos.getZ() + 0.5 + (level.random.nextDouble() - 0.5) * 2.0;
            level.sendParticles((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private void spawnExperienceShower(ServerLevel level, BlockPos pos) {
        double z;
        double y;
        double x;
        int i;
        for (i = 0; i < 10; ++i) {
            x = (double)pos.getX() + 0.5 + (level.random.nextDouble() - 0.5) * 2.0;
            y = (double)pos.getY() + 3.0 + level.random.nextDouble() * 2.0;
            z = (double)pos.getZ() + 0.5 + (level.random.nextDouble() - 0.5) * 2.0;
            ExperienceOrb orb = new ExperienceOrb((Level)level, x, y, z, 5 + level.random.nextInt(10));
            level.addFreshEntity((Entity)orb);
        }
        for (i = 0; i < 30; ++i) {
            x = (double)pos.getX() + 0.5 + (level.random.nextDouble() - 0.5) * 3.0;
            y = (double)pos.getY() + 0.5 + level.random.nextDouble() * 4.0;
            z = (double)pos.getZ() + 0.5 + (level.random.nextDouble() - 0.5) * 3.0;
            level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }
}

