/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.config;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.shwg.smoothswapping.SmoothSwapping;
import dev.shwg.smoothswapping.config.Config;
import dev.shwg.smoothswapping.config.neoforge.ConfigManagerImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;

public class ConfigManager {
    private static File file;
    private static Config config;

    private static void prepareConfigFile() {
        if (file != null) {
            return;
        }
        file = ConfigManager.getConfigPath().resolve("smoothswapping.json").toFile();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigPath() {
        return ConfigManagerImpl.getConfigPath();
    }

    public static Config initializeConfig() {
        if (config != null) {
            return config;
        }
        config = new Config();
        ConfigManager.load();
        return config;
    }

    private static void load() {
        ConfigManager.prepareConfigFile();
        try {
            BufferedReader br;
            Config parsed;
            if (!file.exists()) {
                ConfigManager.save();
            }
            if (file.exists() && (parsed = (Config)SmoothSwapping.GSON.fromJson((Reader)(br = new BufferedReader(new FileReader(file))), Config.class)) != null) {
                config = parsed;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't load Smooth Swapping configuration file; reverting to defaults");
        }
    }

    public static void save() {
        ConfigManager.prepareConfigFile();
        String jsonString = SmoothSwapping.GSON.toJson((Object)config);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save Smooth Swapping configuration file");
        }
    }

    public static Config getConfig() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }
}

