/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.config;

import com.mojang.serialization.Codec;
import dev.shwg.smoothswapping.Vec2;
import dev.shwg.smoothswapping.config.CatmullRomWidget;
import dev.shwg.smoothswapping.config.Config;
import dev.shwg.smoothswapping.config.ConfigManager;
import dev.shwg.smoothswapping.config.InventoryWidget;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class ConfigScreen
extends Screen {
    CatmullRomWidget catmullRomWidget;
    InventoryWidget inventoryWidget;
    Config config = ConfigManager.getConfig();
    OptionInstance<Integer> animationSpeedOption;
    OptionInstance<Boolean> toggleOption = OptionInstance.createBoolean((String)"smoothswapping.config.toggle", (OptionInstance.TooltipSupplier)OptionInstance.noTooltip(), (optionText, value) -> {
        if (value.booleanValue()) {
            return Component.translatable((String)"smoothswapping.config.toggle.on").setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN));
        }
        return Component.translatable((String)"smoothswapping.config.toggle.off").setStyle(Style.EMPTY.withColor(ChatFormatting.RED));
    }, (boolean)this.config.getToggleMod(), value -> this.config.setToggleMod((Boolean)value));
    private final int oldAnimationSpeed;
    Screen parentScreen;
    List<Vec2> oldPoints;

    public ConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"smoothswapping.config.menu"));
        this.animationSpeedOption = new OptionInstance("smoothswapping.config.option.animationspeed", OptionInstance.noTooltip(), (optionText, value) -> Component.translatable((String)"smoothswapping.config.option.animationspeed.speed").append(": ").append((Component)Component.literal((String)(value + "%"))), (OptionInstance.ValueSet)new OptionInstance.IntRange(1, 50).xmap(value -> value * 10, value -> value / 10, true), Codec.intRange((int)10, (int)500), (Object)this.config.getAnimationSpeed(), value -> this.config.setAnimationSpeed((int)value));
        this.oldAnimationSpeed = this.config.getAnimationSpeed();
        this.parentScreen = parent;
        this.oldPoints = this.config.getCurvePoints();
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)this.toggleOption.createButton(Minecraft.getInstance().options, this.width / 2 - 94, this.height / 5 - 20, 188));
        this.addRenderableWidget((GuiEventListener)this.animationSpeedOption.createButton(Minecraft.getInstance().options, this.width / 2 - 94, this.height / 5 + 5, 188));
        this.catmullRomWidget = new CatmullRomWidget(this.width / 2 - 84 - 10, this.height / 3, 64, 64, 12, 4, 4, this.config.getCurvePoints());
        this.inventoryWidget = new InventoryWidget(this.width / 2 + 10, this.height / 3, 3, 4, (Component)Component.translatable((String)"smoothswapping.config.testinventory"));
        this.addRenderableWidget((GuiEventListener)this.catmullRomWidget);
        this.addRenderableWidget((GuiEventListener)this.inventoryWidget);
        Button resetButton = Button.builder((Component)Component.translatable((String)"smoothswapping.config.option.animationspeed.reset"), button -> this.catmullRomWidget.reset()).bounds(this.width / 2 - 84 - 10, this.height / 3 + 86 + 4, 88, 20).build();
        this.addRenderableWidget((GuiEventListener)resetButton);
        Button saveButton = Button.builder((Component)Component.translatable((String)"smoothswapping.config.save"), button -> {
            ConfigManager.save();
            Minecraft.getInstance().setScreen(this.parentScreen);
        }).bounds(this.width / 2 + 10, this.height - 30, 88, 20).build();
        this.addRenderableWidget((GuiEventListener)saveButton);
        Button exitButton = Button.builder((Component)Component.translatable((String)"smoothswapping.config.exit"), button -> this.onClose()).bounds(this.width / 2 - 84 - 10, this.height - 30, 88, 20).build();
        this.addRenderableWidget((GuiEventListener)exitButton);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, 10, -1);
        this.config.setCurvePoints(this.catmullRomWidget.getPoints());
    }

    public void onClose() {
        this.config.setCurvePoints(this.oldPoints);
        this.config.setAnimationSpeed(this.oldAnimationSpeed);
        Minecraft.getInstance().setScreen(this.parentScreen);
    }
}

