/*
 * Decompiled with CFR 0.152.
 */
package telepathicgrunt.structure_layout_optimizer.utils;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import telepathicgrunt.structure_layout_optimizer.utils.PalettedStructureBlockInfoListIterator;

public class PalettedStructureBlockInfoList
implements List<StructureTemplate.StructureBlockInfo> {
    private static final long[] EMPTY_DATA = new long[0];
    private static final CompoundTag[] NULL_TAGS = new CompoundTag[]{null};
    private static final String UNSUPPORTED_OPERATION_ERROR_MESSAGE = "Structure Layout Optimizer: No mod should be modifying a StructureTemplate's Palette itself. Please reach out to Structure Layout Optimizer dev for this crash to investigate this mod compat issue.";
    protected final long[] data;
    protected final BlockState[] states;
    protected final CompoundTag[] nbts;
    protected final int xBits;
    protected final int yBits;
    protected final int zBits;
    protected final int stateBits;
    protected final int nbtBits;
    protected final int bitsPerEntry;
    protected final int size;
    private WeakReference<List<StructureTemplate.StructureBlockInfo>> cachedStructureBlockInfoList = new WeakReference<Object>(null);

    public PalettedStructureBlockInfoList(List<StructureTemplate.StructureBlockInfo> infos) {
        this(infos, null);
    }

    public PalettedStructureBlockInfoList(List<StructureTemplate.StructureBlockInfo> infos, Predicate<StructureTemplate.StructureBlockInfo> predicate) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        ArrayList<CompoundTag> tags = new ArrayList<CompoundTag>();
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (StructureTemplate.StructureBlockInfo info : infos) {
            int tag;
            if (predicate != null && !predicate.test(info)) continue;
            int state = states.indexOf(info.state());
            if (state == -1) {
                state = states.size();
                states.add(info.state());
            }
            if ((tag = PalettedStructureBlockInfoList.indexOf(tags, info.nbt())) == -1) {
                tag = tags.size();
                tags.add(info.nbt());
            }
            int x = info.pos().getX();
            int y = info.pos().getY();
            int z = info.pos().getZ();
            if (x < 0 || y < 0 || z < 0) {
                throw new RuntimeException("StructureLayoutOptimizer: Invalid StructureBlockInfo position: " + String.valueOf(info.pos()));
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z > maxZ) {
                maxZ = z;
            }
            entries.add(new Entry(x, y, z, state, tag));
        }
        this.xBits = PalettedStructureBlockInfoList.bits(maxX);
        this.yBits = PalettedStructureBlockInfoList.bits(maxY);
        this.zBits = PalettedStructureBlockInfoList.bits(maxZ);
        this.stateBits = PalettedStructureBlockInfoList.bits(states.size() - 1);
        this.nbtBits = PalettedStructureBlockInfoList.bits(tags.size() - 1);
        this.bitsPerEntry = this.xBits + this.yBits + this.zBits + this.stateBits + this.nbtBits;
        if (this.bitsPerEntry > 64) {
            throw new RuntimeException("StructureLayoutOptimizer: Too many bits per entry: " + this.bitsPerEntry);
        }
        this.size = entries.size();
        if (this.bitsPerEntry != 0) {
            int entriesPerLong = 64 / this.bitsPerEntry;
            this.data = new long[(this.size + entriesPerLong - 1) / entriesPerLong];
            for (int i = 0; i < this.size; ++i) {
                int n = i / entriesPerLong;
                this.data[n] = this.data[n] | ((Entry)entries.get(i)).compress(this.xBits, this.yBits, this.zBits, this.stateBits) << i % entriesPerLong * this.bitsPerEntry;
            }
        } else {
            this.data = EMPTY_DATA;
        }
        this.states = states.toArray(new BlockState[0]);
        this.nbts = tags.size() == 1 && tags.get(0) == null ? NULL_TAGS : tags.toArray(new CompoundTag[0]);
    }

    private static int bits(int i) {
        int bits = 0;
        while (i >= 1 << bits) {
            ++bits;
        }
        return bits;
    }

    private static <T> int indexOf(List<T> list, T o) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != o) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StructureTemplate.StructureBlockInfo> convertBackToStructureBlockInfoListAndCache() {
        long[] lArray = this.data;
        synchronized (this.data) {
            List structureBlockInfos = (List)this.cachedStructureBlockInfoList.get();
            if (structureBlockInfos != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return structureBlockInfos;
            }
            structureBlockInfos = new ObjectArrayList((Iterator)new PalettedStructureBlockInfoListIterator(this));
            this.cachedStructureBlockInfoList = new WeakReference<List>(structureBlockInfos);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return structureBlockInfos;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @NotNull
    public Iterator<StructureTemplate.StructureBlockInfo> iterator() {
        return this.convertBackToStructureBlockInfoListAndCache().iterator();
    }

    @Override
    @NotNull
    public ListIterator<StructureTemplate.StructureBlockInfo> listIterator() {
        return this.convertBackToStructureBlockInfoListAndCache().listIterator();
    }

    @Override
    @NotNull
    public ListIterator<StructureTemplate.StructureBlockInfo> listIterator(int index) {
        return this.convertBackToStructureBlockInfoListAndCache().listIterator(index);
    }

    @Override
    public boolean contains(Object o) {
        return this.convertBackToStructureBlockInfoListAndCache().contains(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return new HashSet<StructureTemplate.StructureBlockInfo>(this.convertBackToStructureBlockInfoListAndCache()).containsAll(c);
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.convertBackToStructureBlockInfoListAndCache().toArray();
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        return this.convertBackToStructureBlockInfoListAndCache().toArray(a);
    }

    @Override
    public StructureTemplate.StructureBlockInfo get(int index) {
        return this.convertBackToStructureBlockInfoListAndCache().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.convertBackToStructureBlockInfoListAndCache().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.convertBackToStructureBlockInfoListAndCache().lastIndexOf(o);
    }

    @Override
    @NotNull
    public List<StructureTemplate.StructureBlockInfo> subList(int fromIndex, int toIndex) {
        return this.convertBackToStructureBlockInfoListAndCache().subList(fromIndex, toIndex);
    }

    @Override
    public StructureTemplate.StructureBlockInfo set(int index, StructureTemplate.StructureBlockInfo element) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_ERROR_MESSAGE);
    }

    @Override
    public void add(int index, StructureTemplate.StructureBlockInfo element) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_ERROR_MESSAGE);
    }

    @Override
    public boolean add(StructureTemplate.StructureBlockInfo info) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_ERROR_MESSAGE);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_ERROR_MESSAGE);
    }

    @Override
    public StructureTemplate.StructureBlockInfo remove(int index) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_ERROR_MESSAGE);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends StructureTemplate.StructureBlockInfo> c) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_ERROR_MESSAGE);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends StructureTemplate.StructureBlockInfo> c) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_ERROR_MESSAGE);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_ERROR_MESSAGE);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_ERROR_MESSAGE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_ERROR_MESSAGE);
    }

    private static class Entry {
        private final int x;
        private final int y;
        private final int z;
        private final int state;
        private final int nbt;

        private Entry(int x, int y, int z, int state, int nbt) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.state = state;
            this.nbt = nbt;
        }

        private long compress(int xBits, int yBits, int zBits, int stateBits) {
            return (long)this.x + ((long)this.y + ((long)this.z + ((long)this.state + ((long)this.nbt << stateBits) << zBits) << yBits) << xBits);
        }
    }
}

