/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.tintedcampfires.campfire;

import com.cozary.tintedcampfires.campfire.AbstractTintedCampfireBlockEntity;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTintedCampfire
extends CampfireBlock {
    protected final boolean spawnParticles;
    protected final int fireDamage;

    public AbstractTintedCampfire(boolean spawnParticles, int fireDamage, BlockBehaviour.Properties properties, String name) {
        super(true, 1, properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(AbstractTintedCampfire.litBlockEmission(15)).noOcclusion().ignitedByLava().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)Identifier.fromNamespaceAndPath((String)"tintedcampfires", (String)name))));
        this.spawnParticles = spawnParticles;
        this.fireDamage = fireDamage;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static ToIntFunction<BlockState> litBlockEmission(int p_50760_) {
        return p_50763_ -> (Boolean)p_50763_.getValue((Property)BlockStateProperties.LIT) != false ? p_50760_ : 0;
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof AbstractTintedCampfireBlockEntity) {
            AbstractTintedCampfireBlockEntity campfireEntity = (AbstractTintedCampfireBlockEntity)entity;
            ItemStack itemstack = player.getItemInHand(hand);
            if (level.recipeAccess().propertySet(RecipePropertySet.CAMPFIRE_INPUT).test(itemstack)) {
                ServerLevel serverlevel;
                if (level instanceof ServerLevel && campfireEntity.placeFood(serverlevel = (ServerLevel)level, (LivingEntity)player, itemstack)) {
                    player.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                    return InteractionResult.SUCCESS_SERVER;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    protected abstract ParticleOptions getCustomParticle();

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (this.spawnParticles && rand.nextInt(5) == 0) {
                level.addParticle(this.getCustomParticle(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f));
            }
        }
    }

    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    @Nullable
    public abstract <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level var1, BlockState var2, BlockEntityType<T> var3);
}

