/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.tintedcampfires.campfire;

import com.cozary.tintedcampfires.TintedCampfires;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTintedCampfireBlockEntity
extends BlockEntity
implements Clearable {
    protected static final int BURN_COOL_SPEED = 2;
    protected static final int NUM_SLOTS = 4;
    protected final NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected final int[] cookingProgress = new int[4];
    protected final int[] cookingTime = new int[4];

    public AbstractTintedCampfireBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void cookTick(ServerLevel level, BlockPos blockPos, BlockState blockState, AbstractTintedCampfireBlockEntity abstractTintedCampfireBlockEntity, RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> recipeCachedCheck) {
        boolean hasChanges = false;
        for (int i = 0; i < abstractTintedCampfireBlockEntity.items.size(); ++i) {
            SingleRecipeInput input;
            ItemStack result;
            ItemStack stack = (ItemStack)abstractTintedCampfireBlockEntity.items.get(i);
            if (stack.isEmpty()) continue;
            hasChanges = true;
            int n = i;
            abstractTintedCampfireBlockEntity.cookingProgress[n] = abstractTintedCampfireBlockEntity.cookingProgress[n] + 1;
            if (abstractTintedCampfireBlockEntity.cookingProgress[i] < abstractTintedCampfireBlockEntity.cookingTime[i] || !(result = recipeCachedCheck.getRecipeFor((RecipeInput)(input = new SingleRecipeInput(stack)), level).map(recipe -> ((CampfireCookingRecipe)recipe.value()).assemble(input, (HolderLookup.Provider)level.registryAccess())).orElse(stack)).isItemEnabled(level.enabledFeatures())) continue;
            Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)result);
            abstractTintedCampfireBlockEntity.items.set(i, (Object)ItemStack.EMPTY);
            level.sendBlockUpdated(blockPos, blockState, blockState, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((BlockState)blockState));
        }
        if (hasChanges) {
            AbstractTintedCampfireBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    public static void cooldownTick(Level level, BlockPos pos, BlockState state, AbstractTintedCampfireBlockEntity abstractTintedCampfireBlockEntity) {
        boolean hasChanges = false;
        for (int i = 0; i < abstractTintedCampfireBlockEntity.items.size(); ++i) {
            if (abstractTintedCampfireBlockEntity.cookingProgress[i] <= 0) continue;
            hasChanges = true;
            abstractTintedCampfireBlockEntity.cookingProgress[i] = Mth.clamp((int)(abstractTintedCampfireBlockEntity.cookingProgress[i] - 2), (int)0, (int)abstractTintedCampfireBlockEntity.cookingTime[i]);
        }
        if (hasChanges) {
            AbstractTintedCampfireBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, AbstractTintedCampfireBlockEntity abstractTintedCampfireBlockEntity) {
        RandomSource random = level.random;
        if (random.nextFloat() < 0.11f) {
            for (int i = 0; i < random.nextInt(2) + 2; ++i) {
                CampfireBlock.makeParticles((Level)level, (BlockPos)pos, (boolean)((Boolean)state.getValue((Property)CampfireBlock.SIGNAL_FIRE)), (boolean)false);
            }
        }
        int baseDir = ((Direction)state.getValue((Property)CampfireBlock.FACING)).get2DDataValue();
        for (int i = 0; i < abstractTintedCampfireBlockEntity.items.size(); ++i) {
            if (((ItemStack)abstractTintedCampfireBlockEntity.items.get(i)).isEmpty() || !(random.nextFloat() < 0.2f)) continue;
            Direction direction = Direction.from2DDataValue((int)Math.floorMod(i + baseDir, 4));
            float offset = 0.3125f;
            double dx = (double)pos.getX() + 0.5 - (double)((float)direction.getStepX() * offset) + (double)((float)direction.getClockWise().getStepX() * offset);
            double dy = (double)pos.getY() + 0.5;
            double dz = (double)pos.getZ() + 0.5 - (double)((float)direction.getStepZ() * offset) + (double)((float)direction.getClockWise().getStepZ() * offset);
            for (int j = 0; j < 4; ++j) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, dx, dy, dz, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.items.clear();
        ContainerHelper.loadAllItems((ValueInput)input, this.items);
        input.getIntArray("CookingTimes").ifPresentOrElse(savedCookingProgress -> System.arraycopy(savedCookingProgress, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, ((int[])savedCookingProgress).length)), () -> Arrays.fill(this.cookingProgress, 0));
        input.getIntArray("CookingTotalTimes").ifPresentOrElse(savedCookingTotalTimes -> System.arraycopy(savedCookingTotalTimes, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, ((int[])savedCookingTotalTimes).length)), () -> Arrays.fill(this.cookingTime, 0));
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        ContainerHelper.saveAllItems((ValueOutput)output, this.items, (boolean)true);
        output.putIntArray("CookingTimes", this.cookingProgress);
        output.putIntArray("CookingTotalTimes", this.cookingTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag compoundtag;
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(this.problemPath(), TintedCampfires.LOG);){
            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)registries);
            ContainerHelper.saveAllItems((ValueOutput)tagvalueoutput, this.items, (boolean)true);
            compoundtag = tagvalueoutput.buildResult();
        }
        return compoundtag;
    }

    public boolean placeFood(ServerLevel level, @Nullable LivingEntity entity, ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (!itemStack.isEmpty()) continue;
            Optional recipeHolder = level.recipeAccess().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)new SingleRecipeInput(stack), (Level)level);
            if (recipeHolder.isEmpty()) {
                return false;
            }
            this.cookingTime[i] = ((CampfireCookingRecipe)((RecipeHolder)recipeHolder.get()).value()).cookingTime();
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)stack.consumeAndReturn(1, entity));
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    protected void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void preRemoveSideEffects(BlockPos blockPos, BlockState blockState) {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)blockPos, this.getItems());
        }
    }

    protected void applyImplicitComponents(DataComponentGetter input) {
        super.applyImplicitComponents(input);
        ((ItemContainerContents)input.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
    }

    public void removeComponentsFromTag(ValueOutput output) {
        output.discard("Items");
    }
}

