/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.tintedcampfires.datagen;

import com.cozary.tintedcampfires.datagen.ModBlockTagProvider;
import com.cozary.tintedcampfires.datagen.ModLootTableProvider;
import com.cozary.tintedcampfires.datagen.ModModelProvider;
import com.cozary.tintedcampfires.datagen.ModRecipeProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="tintedcampfires")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new ModModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new ModRecipeProvider.Runner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new ModBlockTagProvider(packOutput, lookupProvider));
        event.createProvider(output -> new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ModLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Server event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new ModModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new ModRecipeProvider.Runner(packOutput, lookupProvider));
    }
}

