/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.tintedcampfires.datagen;

import com.cozary.tintedcampfires.init.ModBlocks;
import java.util.Optional;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;

public class ModModelProvider
extends ModelProvider {
    private static final ModelTemplate TWO_LAYER_ITEM = new ModelTemplate(Optional.of(Identifier.parse((String)"item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1});

    public ModModelProvider(PackOutput output) {
        super(output, "tintedcampfires");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.createCampfires(blockModels, itemModels, ModBlocks.BLACK_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.BLUE_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.BROWN_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.GREEN_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.RED_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.WHITE_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.YELLOW_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.LIGHT_BLUE_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.LIGHT_GRAY_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.LIME_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.MAGENTA_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.ORANGE_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.PINK_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.CYAN_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.GRAY_CAMPFIRE.get());
        this.createCampfires(blockModels, itemModels, ModBlocks.PURPLE_CAMPFIRE.get());
    }

    public void createCampfires(BlockModelGenerators blockModels, ItemModelGenerators itemModels, Block ... campfireBlocks) {
        MultiVariant multivariantOff = BlockModelGenerators.plainVariant((Identifier)ModelLocationUtils.decorateBlockModelLocation((String)"campfire_off"));
        for (Block block : campfireBlocks) {
            MultiVariant multivariantOn = BlockModelGenerators.plainVariant((Identifier)ModelTemplates.CAMPFIRE.create(block, TextureMapping.campfire((Block)block), blockModels.modelOutput));
            Identifier itemModelLoc = ModelLocationUtils.getModelLocation((Item)block.asItem());
            Identifier overlayTexture = Identifier.fromNamespaceAndPath((String)"tintedcampfires", (String)"item/campfire_item_overlay");
            TextureMapping itemTextures = new TextureMapping().put(TextureSlot.LAYER0, itemModelLoc).put(TextureSlot.LAYER1, overlayTexture);
            TWO_LAYER_ITEM.create(itemModelLoc, itemTextures, itemModels.modelOutput);
            itemModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((Identifier)itemModelLoc));
            blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (MultiVariant)multivariantOn, (MultiVariant)multivariantOff)).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING_ALT));
        }
    }
}

