/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.tintedcampfires.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class CampfireDispenseBehavior
extends DefaultDispenseItemBehavior {
    private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected ItemStack execute(BlockSource blockSource, @NotNull ItemStack itemStack) {
        ServerLevel level = blockSource.level();
        Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
        BlockPos blockpos = blockSource.pos().relative(direction);
        BlockState blockstate = level.getBlockState(blockpos);
        Block block = blockstate.getBlock();
        if (!(block instanceof CampfireBlock)) return this.defaultBehavior.dispense(blockSource, itemStack);
        CampfireBlock campfire = (CampfireBlock)block;
        if (!CampfireBlock.canLight((BlockState)blockstate)) return this.defaultBehavior.dispense(blockSource, itemStack);
        if (!blockstate.hasProperty((Property)BlockStateProperties.LIT)) {
            return this.defaultBehavior.dispense(blockSource, itemStack);
        }
        level.setBlockAndUpdate(blockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
        level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, blockpos);
        itemStack.hurtAndBreak(1, level, null, p_348117_ -> {});
        return itemStack;
    }
}

