/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.tintedcampfires.dispenser;

import com.cozary.tintedcampfires.init.ModBlocks;
import com.cozary.tintedcampfires.init.particles.ModParticles;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class SetColorDispenseBehavior
extends DefaultDispenseItemBehavior {
    private static final Map<Item, CampfireData> campfireDataMap = new HashMap<Item, CampfireData>();
    private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected ItemStack execute(BlockSource p_123412_, @NotNull ItemStack p_123413_) {
        ServerLevel level = p_123412_.level();
        Direction direction = (Direction)p_123412_.state().getValue((Property)DispenserBlock.FACING);
        BlockPos pos = p_123412_.pos().relative(direction);
        BlockState state = level.getBlockState(pos);
        Item item = p_123413_.getItem();
        if (!(state.getBlock() instanceof CampfireBlock)) return this.defaultBehavior.dispense(p_123412_, p_123413_);
        Direction direction1 = (Direction)state.getValue((Property)CampfireBlock.FACING);
        Random rand = new Random();
        double d0 = rand.nextGaussian() * 0.02;
        double d1 = rand.nextGaussian() * 0.02;
        double d2 = rand.nextGaussian() * 0.02;
        if (level.isClientSide()) return p_123413_;
        CampfireData campfireData = campfireDataMap.get(item);
        if (campfireData == null) return this.defaultBehavior.dispense(p_123412_, p_123413_);
        level.setBlockAndUpdate(pos, (BlockState)campfireData.blockState.setValue((Property)CampfireBlock.FACING, (Comparable)direction1));
        level.sendParticles(campfireData.particle, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 50, d1, d2, d0, 0.1);
        p_123413_.shrink(1);
        return p_123413_;
    }

    static {
        campfireDataMap.put(Items.BLACK_DYE, new CampfireData(ModBlocks.BLACK_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.BLACK_LAVA.get()));
        campfireDataMap.put(Items.RED_DYE, new CampfireData(ModBlocks.RED_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.RED_LAVA.get()));
        campfireDataMap.put(Items.GREEN_DYE, new CampfireData(ModBlocks.GREEN_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.GREEN_LAVA.get()));
        campfireDataMap.put(Items.BROWN_DYE, new CampfireData(ModBlocks.BROWN_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.BROWN_LAVA.get()));
        campfireDataMap.put(Items.BLUE_DYE, new CampfireData(ModBlocks.BLUE_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.BLUE_LAVA.get()));
        campfireDataMap.put(Items.PURPLE_DYE, new CampfireData(ModBlocks.PURPLE_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.PURPLE_LAVA.get()));
        campfireDataMap.put(Items.CYAN_DYE, new CampfireData(ModBlocks.CYAN_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.CYAN_LAVA.get()));
        campfireDataMap.put(Items.LIGHT_GRAY_DYE, new CampfireData(ModBlocks.LIGHT_GRAY_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.LIGHT_GRAY_LAVA.get()));
        campfireDataMap.put(Items.GRAY_DYE, new CampfireData(ModBlocks.GRAY_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.GRAY_LAVA.get()));
        campfireDataMap.put(Items.PINK_DYE, new CampfireData(ModBlocks.PINK_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.PINK_LAVA.get()));
        campfireDataMap.put(Items.LIME_DYE, new CampfireData(ModBlocks.LIME_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.LIME_LAVA.get()));
        campfireDataMap.put(Items.YELLOW_DYE, new CampfireData(ModBlocks.YELLOW_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.YELLOW_LAVA.get()));
        campfireDataMap.put(Items.LIGHT_BLUE_DYE, new CampfireData(ModBlocks.LIGHT_BLUE_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.LIGHT_BLUE_LAVA.get()));
        campfireDataMap.put(Items.MAGENTA_DYE, new CampfireData(ModBlocks.MAGENTA_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.MAGENTA_LAVA.get()));
        campfireDataMap.put(Items.ORANGE_DYE, new CampfireData(ModBlocks.ORANGE_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.ORANGE_LAVA.get()));
        campfireDataMap.put(Items.WHITE_DYE, new CampfireData(ModBlocks.WHITE_CAMPFIRE.get().defaultBlockState(), (ParticleOptions)ModParticles.WHITE_LAVA.get()));
    }

    public record CampfireData(BlockState blockState, ParticleOptions particle) {
    }
}

