/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.tintedcampfires.init.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public class ColorCampfireParticle
extends SingleQuadParticle {
    public ColorCampfireParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite sprite) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.xd *= (double)0.8f;
        this.yd *= (double)0.8f;
        this.zd *= (double)0.8f;
        this.yd = this.random.nextFloat() * 0.4f + 0.05f;
        this.quadSize *= this.random.nextFloat() * 2.0f + 0.2f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
    }

    public float getQuadSize(float scaleFactor) {
        float f = ((float)this.age + scaleFactor) / (float)this.lifetime;
        return this.quadSize * (1.0f - f * f);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        float f = (float)this.age / (float)this.lifetime;
        if (this.random.nextFloat() > f) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, this.x, this.y, this.z, this.xd, this.yd, this.zd);
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.03;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.999f;
            this.yd *= (double)0.999f;
            this.zd *= (double)0.999f;
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }

    public int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        int k = i >> 16 & 0xFF;
        return 0xF0 | k << 16;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            TextureAtlasSprite sprite = this.spriteSet.get(random);
            ColorCampfireParticle particle = new ColorCampfireParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
            return particle;
        }
    }
}

