/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.treetimberneo;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="treetimberneo")
public class Treetimberneo {
    public static final String MODID = "treetimberneo";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Treetimberneo(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public boolean isLog(BlockState blockState) {
        return BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString().endsWith("_log");
    }

    public boolean isAxe(ItemStack itemStack) {
        return BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString().endsWith("_axe");
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer().isShiftKeyDown()) {
            return;
        }
        ItemStack itemStack = event.getPlayer().getMainHandItem();
        if (!this.isAxe(itemStack)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState blockState = event.getState();
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
        if (this.isLog(blockState)) {
            blocks.add(pos);
            temp.add(pos);
            while (!temp.isEmpty()) {
                BlockPos pos1 = (BlockPos)temp.getFirst();
                for (Direction dir : Direction.values()) {
                    if (event.getLevel() == null) continue;
                    BlockPos blockPos = pos1.relative(dir);
                    if (!this.isLog(event.getLevel().getBlockState(blockPos)) || blocks.contains(blockPos)) continue;
                    blocks.add(blockPos);
                    temp.add(blockPos);
                }
                temp.removeFirst();
            }
            if (!this.isTree(blocks, (Level)event.getLevel())) {
                return;
            }
            for (BlockPos blockPos : blocks) {
                event.getPlayer().getMainHandItem().getItem().mineBlock(event.getPlayer().getMainHandItem(), (Level)event.getLevel(), event.getLevel().getBlockState(blockPos), blockPos, (LivingEntity)event.getPlayer());
                event.getLevel().destroyBlock(blockPos, true);
                if (!itemStack.isDamageableItem()) continue;
                itemStack.hurtAndBreak(1, (LivingEntity)event.getPlayer(), event.getPlayer().getEquipmentSlotForItem(itemStack));
            }
        }
    }

    public boolean isTree(List<BlockPos> blockPos, Level level) {
        BlockPos bs = blockPos.getFirst();
        if (bs != null) {
            int maxy = blockPos.stream().mapToInt(Vec3i::getY).max().getAsInt();
            BlockPos bs2 = new BlockPos(bs.getX(), maxy, bs.getZ());
            int count = 0;
            for (Direction direction : Direction.values()) {
                BlockState blockState = level.getBlockState(bs2.relative(direction));
                if (!BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString().endsWith("_leaves")) continue;
                ++count;
            }
            if (count >= 2) {
                return true;
            }
        }
        return false;
    }

    @EventBusSubscriber(modid="treetimberneo", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

